/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.block.util.IShovelFlattenable;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class GrassSlabBlock
extends SlabBlock
implements IShovelFlattenable {
    private final Block parent;
    private final boolean spreads;

    public GrassSlabBlock(Block parent, BlockBehaviour.Properties properties) {
        super(properties);
        this.parent = parent;
        this.spreads = parent instanceof SpreadingSnowyDirtBlock;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61451_});
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        if (state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
            return false;
        }
        return this.parent.m_49966_().canSustainPlant(level, pos, facing, plantable);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        this.parent.m_214162_(state, level, pos, rand);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            if (state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.BOTTOM) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(GrassSlabBlock.isSnowySetting(facingState)));
            } else if (facingState.m_60734_() instanceof IPlantable) {
                level.m_46961_(facingPos, true);
            }
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        BlockState aboveState = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.BOTTOM && GrassSlabBlock.isSnowySetting(aboveState)));
    }

    private static boolean isSnowySetting(BlockState pState) {
        return pState.m_204336_(BlockTags.f_144279_);
    }

    public static BlockState getStateAtPosition(BlockState state, ServerLevel level, BlockPos pos) {
        if (state.m_61138_((Property)BlockStateProperties.f_61451_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(GrassSlabBlock.isSnowySetting(level.m_8055_(pos.m_7494_()))));
        }
        return state;
    }

    @Override
    public BlockState getShovelFlattenedState(BlockState state, LevelReader level, BlockPos pos) {
        return IModifyState.mergeStates((BlockState)RediscoveredBlocks.dirt_path_slab.m_49966_(), (BlockState)state);
    }

    public static boolean canBeGrass(BlockState state, LevelReader level, BlockPos pos) {
        boolean isBottom;
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        SlabType slabType = state.m_61138_((Property)SlabBlock.f_56353_) ? (SlabType)state.m_61143_((Property)SlabBlock.f_56353_) : SlabType.DOUBLE;
        boolean bl = isBottom = slabType == SlabType.BOTTOM;
        if (!isBottom && aboveState.m_60713_(Blocks.f_50125_) && (Integer)aboveState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (!isBottom && aboveState.m_60819_().m_76186_() == 8) {
            return false;
        }
        if (isBottom && ((Boolean)state.m_61143_((Property)SlabBlock.f_56354_)).booleanValue()) {
            return false;
        }
        return !Shapes.m_83117_((VoxelShape)state.m_60768_((BlockGetter)level, pos), (VoxelShape)aboveState.m_60768_((BlockGetter)level, abovePos), (Direction)Direction.UP);
    }

    public static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        return GrassSlabBlock.canBeGrass(state, level, pos) && !level.m_6425_(abovePos).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.spreads) {
            return;
        }
        if (!GrassSlabBlock.canBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.m_46597_(pos, IModifyState.mergeStates((BlockState)RediscoveredBlocks.dirt_slab.m_49966_(), (BlockState)state));
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (level.m_46803_(pos.m_7494_()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.m_7918_(rand.m_188503_(3) - 1, rand.m_188503_(5) - 3, rand.m_188503_(3) - 1);
                    BlockState target = level.m_8055_(blockpos);
                    BlockState result = null;
                    if (target.m_60713_(Blocks.f_50493_)) {
                        result = this.parent.m_49966_();
                    } else if (target.m_60713_(RediscoveredBlocks.dirt_slab)) {
                        result = this.m_49966_();
                    }
                    if (result == null || !GrassSlabBlock.canPropagate(target, (LevelReader)level, blockpos)) continue;
                    level.m_46597_(blockpos, IModifyState.mergeStates((BlockState)GrassSlabBlock.getStateAtPosition(result, level, blockpos), (BlockState)target));
                }
            }
        }
    }
}

