/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.google.common.collect.ImmutableList;
import com.legacy.rediscovered.block_entities.GearBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class GearBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public GearBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState defaultState = this.m_49966_();
        for (GearFace enumFace : GearFace.values()) {
            defaultState = (BlockState)defaultState.m_61124_(enumFace.stateProperty, (Comparable)((Object)GearState.NONE));
        }
        this.m_49959_((BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76145_() : Fluids.f_76191_.m_76145_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (GearFace enumFace : GearFace.values()) {
            if (!((GearState)((Object)state.m_61143_(enumFace.stateProperty))).exists() || GearBlock.isSolid(level, pos, enumFace.direction.m_122424_())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSolid(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos offsetPos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(offsetPos).m_60783_((BlockGetter)level, offsetPos, direction);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        level.m_186460_(pos, (Block)this, 0);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof GearBlockEntity) {
                GearBlockEntity gear = (GearBlockEntity)blockEntity;
                gear.onNeighborUpdated(serverLevel, state, pos);
            }
        }
    }

    private void notifyWrapAroundNeighbors(BlockState state, Level level, BlockPos pos) {
        HashSet<BlockPos> positionsToNotify = new HashSet<BlockPos>();
        positionsToNotify.add(pos);
        for (GearFace gearFace : GearFace.values()) {
            if (!((GearState)((Object)state.m_61143_(gearFace.stateProperty))).exists()) continue;
            for (Direction dir : Direction.values()) {
                if (gearFace.direction.m_122434_() == dir.m_122434_()) continue;
                positionsToNotify.add(pos.m_121945_(dir).m_121945_(gearFace.direction));
            }
        }
        for (BlockPos notifyPos : positionsToNotify) {
            BlockEntity blockEntity;
            BlockState notifyState = level.m_8055_(notifyPos);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!notifyState.m_60713_((Block)this) || !((blockEntity = level.m_7702_(notifyPos)) instanceof GearBlockEntity)) continue;
            GearBlockEntity gear = (GearBlockEntity)blockEntity;
            gear.onNeighborUpdated(serverLevel, notifyState, notifyPos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        this.notifyWrapAroundNeighbors(state, level, pos);
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        this.notifyWrapAroundNeighbors(state, level, pos);
        super.m_6807_(state, level, pos, oldState, movedByPiston);
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        for (GearFace enumFace : GearFace.values()) {
            if (state.m_60734_() != this) {
                return;
            }
            if (!((GearState)((Object)state.m_61143_(enumFace.stateProperty))).exists() || GearBlock.isSolid((LevelReader)serverLevel, pos, enumFace.direction.m_122424_())) continue;
            GearBlock.m_49950_((BlockState)((BlockState)this.m_49966_().m_61124_(enumFace.stateProperty, (Comparable)((Object)GearState.GEAR))), (Level)serverLevel, (BlockPos)pos);
            serverLevel.m_46597_(pos, this.removeGear(state, enumFace));
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public BlockState removeGear(BlockState state, GearFace gearFace) {
        state = (BlockState)state.m_61124_(gearFace.stateProperty, (Comparable)((Object)GearState.NONE));
        for (GearFace enumFace : GearFace.values()) {
            if (!((GearState)((Object)state.m_61143_(enumFace.stateProperty))).exists()) continue;
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction faceToPlace = context.m_43719_().m_122424_();
        BlockState oldState = level.m_8055_(clickedPos);
        if (oldState.m_60713_((Block)this)) {
            return (BlockState)oldState.m_61124_(GearFace.get((Direction)faceToPlace).stateProperty, (Comparable)((Object)GearState.GEAR));
        }
        if (this.m_49966_().m_60710_((LevelReader)level, clickedPos)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(GearFace.get((Direction)faceToPlace).stateProperty, (Comparable)((Object)GearState.GEAR))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_6425_(clickedPos).m_192917_((Fluid)Fluids.f_76193_)));
        }
        return null;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        if (useContext.m_43722_().m_150930_(this.m_5456_()) && !((GearState)((Object)state.m_61143_(GearFace.get((Direction)useContext.m_43719_().m_122424_()).stateProperty))).exists()) {
            if (useContext.m_7058_()) {
                return true;
            }
            return true;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83040_();
        for (GearFace enumFace : GearFace.values()) {
            if (!((GearState)((Object)state.m_61143_(enumFace.stateProperty))).exists()) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)enumFace.shape);
        }
        return shape;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return true;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> states) {
        for (GearFace gearFace : GearFace.values()) {
            states.m_61104_(new Property[]{gearFace.stateProperty});
        }
        states.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GearBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? GearBlock.m_152132_(blockEntityType, RediscoveredBlockEntityTypes.GEAR, GearBlockEntity::clientTick) : null;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation != Rotation.NONE) {
            HashMap<Direction, GearState> gears = new HashMap<Direction, GearState>();
            for (Direction dir : VoxelShapeUtil.HORIZONTAL_DIRS) {
                gears.put(dir, (GearState)((Object)state.m_61143_(GearFace.get((Direction)dir).stateProperty)));
            }
            for (Direction dir : VoxelShapeUtil.HORIZONTAL_DIRS) {
                Direction rotatedDir = rotation.m_55954_(dir);
                state = (BlockState)state.m_61124_(GearFace.get((Direction)rotatedDir).stateProperty, (Comparable)((Object)((GearState)((Object)gears.get(dir)))));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            GearState e = (GearState)((Object)state.m_61143_(GearFace.EAST.stateProperty));
            GearState w = (GearState)((Object)state.m_61143_(GearFace.WEST.stateProperty));
            return (BlockState)((BlockState)state.m_61124_(GearFace.EAST.stateProperty, (Comparable)((Object)w))).m_61124_(GearFace.WEST.stateProperty, (Comparable)((Object)e));
        }
        if (mirror == Mirror.LEFT_RIGHT) {
            GearState n = (GearState)((Object)state.m_61143_(GearFace.NORTH.stateProperty));
            GearState s = (GearState)((Object)state.m_61143_(GearFace.SOUTH.stateProperty));
            return (BlockState)((BlockState)state.m_61124_(GearFace.NORTH.stateProperty, (Comparable)((Object)s))).m_61124_(GearFace.SOUTH.stateProperty, (Comparable)((Object)n));
        }
        return state;
    }

    public static enum GearFace {
        DOWN(Direction.DOWN, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)),
        UP(Direction.UP, Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        NORTH(Direction.NORTH, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)),
        SOUTH(Direction.SOUTH, Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)),
        WEST(Direction.WEST, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)),
        EAST(Direction.EAST, Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

        public final Direction direction;
        public final EnumProperty<GearState> stateProperty;
        public final VoxelShape shape;
        public List<Pair<BlockPos, GearFace>> possibleConnections;

        private GearFace(Direction direction, VoxelShape shape) {
            this.direction = direction;
            this.stateProperty = EnumProperty.m_61587_((String)(direction.m_7912_() + "_gear"), GearState.class);
            this.shape = shape;
            if (this.ordinal() != direction.ordinal()) {
                throw new IllegalStateException("GearFace ordinal does not match Direction ordinal");
            }
        }

        public List<Pair<BlockPos, GearFace>> getPossibleConnections(BlockPos gearPos) {
            if (this.possibleConnections == null) {
                ImmutableList.Builder connections = ImmutableList.builder();
                for (Direction dir : Direction.values()) {
                    BlockPos origin = BlockPos.f_121853_;
                    if (dir.m_122434_() == this.direction.m_122434_()) continue;
                    connections.add((Object)Pair.of((Object)origin, (Object)((Object)GearFace.get(dir))));
                    connections.add((Object)Pair.of((Object)origin.m_121945_(dir).m_121945_(this.direction), (Object)((Object)GearFace.get(dir.m_122424_()))));
                    connections.add((Object)Pair.of((Object)origin.m_121945_(dir), (Object)((Object)this)));
                }
                this.possibleConnections = connections.build();
            }
            return this.possibleConnections.stream().map(p -> Pair.of((Object)((BlockPos)p.getLeft()).m_121955_((Vec3i)gearPos), (Object)((Object)((GearFace)((Object)((Object)p.getRight())))))).toList();
        }

        public static GearFace get(Direction direction) {
            return GearFace.values()[direction.ordinal()];
        }
    }

    public static enum GearState implements StringRepresentable
    {
        NONE("none"),
        GEAR("gear");

        final String name;

        private GearState(String name) {
            this.name = name;
        }

        public boolean exists() {
            return this != NONE;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

