/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DragonAltarBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);

    public DragonAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)((Object)Shape.EDGE))).m_61124_(FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction dir = context.m_8125_();
        BlockState state = this.m_49966_();
        if (level.m_8055_(pos.m_121945_(dir)).m_60713_((Block)this)) {
            state = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.CORNER));
        }
        if (level.m_8055_(pos.m_121945_(Direction.NORTH)).m_60713_((Block)this) && level.m_8055_(pos.m_121945_(Direction.SOUTH)).m_60713_((Block)this) && level.m_8055_(pos.m_121945_(Direction.EAST)).m_60713_((Block)this) && level.m_8055_(pos.m_121945_(Direction.WEST)).m_60713_((Block)this)) {
            state = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.CENTER));
        }
        Direction facing = dir.m_122424_();
        if (level.m_8055_(pos.m_121945_(dir.m_122427_())).m_60713_((Block)this) && state.m_61143_(SHAPE) == Shape.CORNER) {
            facing = facing.m_122427_();
        }
        state = (BlockState)state.m_61124_(FACING, (Comparable)facing);
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        if (state.m_61143_(SHAPE) != Shape.CORNER) {
            return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
        }
        Direction facing = (Direction)state.m_61143_(FACING);
        Direction.Axis axis = mirror == Mirror.LEFT_RIGHT ? Direction.Axis.Z : Direction.Axis.X;
        Direction newFace = facing.m_122434_() == axis ? facing.m_122428_() : facing.m_122427_();
        return (BlockState)state.m_61124_(FACING, (Comparable)newFace);
    }

    public static enum Shape implements StringRepresentable
    {
        EDGE("edge"),
        CORNER("corner"),
        CENTER("center");

        final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getLightLevel() {
            return this == CORNER ? 0 : (this == CENTER ? 15 : 7);
        }
    }
}

