/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.block.GrassSlabBlock;
import com.legacy.rediscovered.block.util.IShovelFlattenable;
import com.legacy.rediscovered.block.util.ITillable;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.jarjar.nio.util.Lazy;

public class DirtSlabBlock
extends SlabBlock
implements IShovelFlattenable,
ITillable {
    private static final Lazy<Map<Block, Block>> SPREAD_TABLE = Lazy.of(() -> {
        HashMap<Block, Block> map = new HashMap<Block, Block>();
        map.put(Blocks.f_50440_, RediscoveredBlocks.grass_slab);
        map.put(Blocks.f_50195_, RediscoveredBlocks.mycelium_slab);
        return map;
    });

    public DirtSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!DirtSlabBlock.canSpreadOn(state)) {
            return;
        }
        if (!level.isAreaLoaded(pos, 3)) {
            return;
        }
        if ((state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM ? level.m_46803_(pos) : level.m_46803_(pos.m_7494_())) >= 9) {
            BlockState blockstate = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.m_7918_(rand.m_188503_(3) - 1, rand.m_188503_(5) - 3, rand.m_188503_(3) - 1);
                Block spreadResult = (Block)((Map)SPREAD_TABLE.get()).get(level.m_8055_(blockpos).m_60734_());
                if (spreadResult == null || !GrassSlabBlock.canPropagate(state, (LevelReader)level, pos)) continue;
                level.m_46597_(pos, GrassSlabBlock.getStateAtPosition(IModifyState.mergeStates((BlockState)spreadResult.m_49966_(), (BlockState)state), level, pos));
            }
        }
    }

    private static boolean canSpreadOn(BlockState state) {
        return state.m_60713_(RediscoveredBlocks.dirt_slab);
    }

    @Override
    public BlockState getShovelFlattenedState(BlockState state, LevelReader level, BlockPos pos) {
        return IModifyState.mergeStates((BlockState)RediscoveredBlocks.dirt_path_slab.m_49966_(), (BlockState)state);
    }

    @Override
    public BlockState getHoeTilledState(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_60713_(RediscoveredBlocks.dirt_slab)) {
            return state;
        }
        return IModifyState.mergeStates((BlockState)RediscoveredBlocks.dirt_slab.m_49966_(), (BlockState)state);
    }
}

