/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.util.MountableBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = VoxelShapeUtil.createRotations((VoxelShape)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)6.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)6.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)6.0, (double)4.0), Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0)}));

    public ChairBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState ifluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        return blockstate1;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        if (!level.m_6443_(MountableBlockEntity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)0.3, (double)0.3, (double)0.3), entity -> !entity.m_20197_().isEmpty()).isEmpty()) {
            return 15;
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return RediscoveredBlocks.FURNITURE_PATH_TYPE;
    }

    public static boolean canMount(Level level, BlockPos pos, boolean dismountNonPlayers) {
        if (!level.m_8055_(pos).m_204336_(RediscoveredTags.Blocks.CHAIRS)) {
            return false;
        }
        List listEMB = level.m_45976_(MountableBlockEntity.class, new AABB(pos));
        if (!listEMB.isEmpty()) {
            if (dismountNonPlayers) {
                listEMB.forEach(mount -> mount.m_20153_());
            }
            return false;
        }
        return true;
    }

    public static boolean tryInteract(LivingEntity entity, BlockPos pos, @Nullable InteractionHand hand) {
        Level level = entity.m_9236_();
        if (!ChairBlock.canMount(level, pos, entity instanceof Player)) {
            return false;
        }
        float mountingX = (float)pos.m_123341_() + 0.5f;
        float mountingY = pos.m_123342_();
        float mountingZ = (float)pos.m_123343_() + 0.5f;
        BlockState state = level.m_8055_(pos);
        MountableBlockEntity mount = new MountableBlockEntity(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), mountingX, mountingY, mountingZ);
        if (state.m_61138_((Property)FACING)) {
            mount.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
            mount.m_5616_(mount.m_146908_());
            mount.m_5618_(mount.m_146908_());
            mount.f_19859_ = mount.m_146908_();
        }
        level.m_7967_((Entity)mount);
        entity.m_6674_(InteractionHand.MAIN_HAND);
        mount.interactBasic(entity);
        return true;
    }
}

