/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class BrittleBlock
extends Block {
    public static final int MIN_STRENGTH = 0;
    public static final int MAX_STRENGTH = 2;
    public static final IntegerProperty STRENGTH = IntegerProperty.m_61631_((String)"strength", (int)0, (int)2);

    public BrittleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(2)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STRENGTH});
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.m_5776_()) {
            if (entity.m_20142_()) {
                level.m_46961_(pos, false);
            }
            if (!entity.m_20161_() && entity instanceof LivingEntity) {
                level.m_186460_(pos, (Block)this, 2);
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance);
        if (!level.m_5776_() && (double)fallDistance >= 0.75) {
            level.m_46961_(pos, false);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos offset = pos.m_121945_(dir);
                BlockState neighbor = level.m_8055_(offset);
                Block block = neighbor.m_60734_();
                if (!(block instanceof BrittleBlock)) continue;
                BrittleBlock brittle = (BrittleBlock)block;
                brittle.weaken(level, neighbor, offset, 1);
            }
        }
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos hitPos = hit.m_82425_();
        if (!level.m_5776_() && projectile.m_142265_(level, hitPos) && projectile.m_6095_().m_204039_(EntityTypeTags.f_13124_)) {
            this.weaken(level, state, hitPos, 1);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        this.weaken((Level)level, state, pos, 1);
    }

    private void weaken(Level level, BlockState state, BlockPos pos, int amount) {
        int strength = (Integer)state.m_61143_((Property)STRENGTH);
        if (strength > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(Mth.m_14045_((int)(strength - amount), (int)0, (int)2))), 3);
        } else {
            level.m_46961_(pos, false);
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

