/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.event.api.GetFakeFireEvent;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class BaseFakeFireBlock
extends BaseFireBlock {
    public BaseFakeFireBlock(BlockBehaviour.Properties properties, float damage) {
        super(properties, damage);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return BaseFakeFireBlock.getState((BlockGetter)context.m_43725_(), context.m_8083_());
    }

    @Nullable
    public static BlockState getState(BlockGetter level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        GetFakeFireEvent event = new GetFakeFireEvent(SoulFireBlock.m_154650_((BlockState)belowState) ? RediscoveredBlocks.fake_soul_fire.m_49966_() : RediscoveredBlocks.fake_fire.m_49966_(), level, pos, belowState);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewFire();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return state.m_60710_((LevelReader)level, pos) ? BaseFakeFireBlock.getState((BlockGetter)level, pos) : Blocks.f_50016_.m_49966_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            return;
        }
        super.m_7892_(state, level, pos, entity);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        level.m_186460_(pos, (Block)this, this.getFireTickDelay(level.f_46441_));
    }

    protected int getFireTickDelay(RandomSource rand) {
        return 30 + rand.m_188503_(10);
    }

    protected boolean isNearRain(Level level, BlockPos pos) {
        return level.m_46471_() && (level.m_46758_(pos) || level.m_46758_(pos.m_122024_()) || level.m_46758_(pos.m_122029_()) || level.m_46758_(pos.m_122012_()) || level.m_46758_(pos.m_122019_()));
    }

    protected boolean m_7599_(BlockState state) {
        return true;
    }

    public static class FakeSoulFireBlock
    extends BaseFakeFireBlock {
        public FakeSoulFireBlock(BlockBehaviour.Properties properties, float damage) {
            super(properties, damage);
        }

        public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
            return SoulFireBlock.m_154650_((BlockState)level.m_8055_(pos.m_7495_()));
        }
    }

    public static class FakeFireBlock
    extends BaseFakeFireBlock {
        public static final IntegerProperty AGE = BlockStateProperties.f_222999_;

        public FakeFireBlock(BlockBehaviour.Properties properties, float damage) {
            super(properties, damage);
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        }

        protected int maxAge() {
            return 4;
        }

        protected IntegerProperty ageProperty() {
            return AGE;
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{this.ageProperty()});
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction neighborDir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
            return this.m_7898_(state, (LevelReader)level, pos) ? this.getStateWithAge(level, pos, (Integer)state.m_61143_((Property)this.ageProperty())) : Blocks.f_50016_.m_49966_();
        }

        protected BlockState getStateWithAge(LevelAccessor level, BlockPos pos, int age) {
            BlockState state = FakeFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos);
            return state.m_61138_((Property)this.ageProperty()) ? (BlockState)state.m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(age)) : state;
        }

        public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
            return (Integer)state.m_61143_((Property)this.ageProperty()) < this.maxAge() && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
        }

        public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
            level.m_186460_(pos, (Block)this, this.getFireTickDelay(rand));
            if (level.m_46469_().m_46207_(GameRules.f_46131_)) {
                BlockPos groundPos = pos.m_7495_();
                BlockState groundState = level.m_8055_(groundPos);
                boolean onInfiniburn = groundState.isFireSource((LevelReader)level, pos, Direction.UP);
                int age = (Integer)state.m_61143_((Property)this.ageProperty());
                if (!onInfiniburn && this.isNearRain((Level)level, pos) && rand.m_188501_() < 0.2f + (float)age * 0.03f) {
                    level.m_7471_(pos, false);
                } else {
                    int newAge;
                    int n = newAge = onInfiniburn ? age : Math.min(this.maxAge(), age + rand.m_188503_(3) / 2);
                    if (newAge >= this.maxAge()) {
                        level.m_7471_(pos, false);
                        return;
                    }
                    if (age != newAge) {
                        state = (BlockState)state.m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(newAge));
                        level.m_7731_(pos, state, 4);
                    }
                }
            }
        }
    }
}

