/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.api;

import com.legacy.rediscovered.block_entities.NetherReactorBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredParticles;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public interface INetherReactorGrowable {
    public static final INetherReactorGrowable DEFAULT_IMPL = new INetherReactorGrowable(){};

    public static INetherReactorGrowable get(BlockState state) {
        INetherReactorGrowable nrg;
        Block block = state.m_60734_();
        return block instanceof INetherReactorGrowable ? (nrg = (INetherReactorGrowable)block) : DEFAULT_IMPL;
    }

    default public Optional<BlockPos> onNetherReactorGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand, NetherReactorBlockEntity netherReactor) {
        if (!state.m_60795_()) {
            BonemealableBlock bonemealable;
            IPlantable plantable;
            Block block = state.m_60734_();
            if (block instanceof IPlantable && (plantable = (IPlantable)block).getPlantType((BlockGetter)level, pos) == PlantType.NETHER) {
                state.m_222972_(level, pos, rand);
                return Optional.of(pos);
            }
            if (state.m_204336_(BlockTags.f_13062_) && block instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, state, level.f_46443_) && bonemealable.m_214167_((Level)level, rand, pos, state)) {
                bonemealable.m_214148_(level, rand, pos, state);
                return Optional.of(pos.m_7494_());
            }
            if (state.m_204336_(BlockTags.f_13077_) && level.m_8055_(pos.m_7494_()).m_60795_()) {
                Block rare;
                Block common;
                if (state.m_60713_(Blocks.f_50690_)) {
                    common = Blocks.f_50693_;
                    rare = Blocks.f_50691_;
                } else {
                    common = Blocks.f_50654_;
                    rare = Blocks.f_50700_;
                }
                level.m_7731_(pos.m_7494_(), (rand.m_188501_() < 0.1f ? rare : common).m_49966_(), 3);
                return Optional.of(pos.m_7494_());
            }
        }
        return Optional.empty();
    }

    default public void displayNetherReactorGrowth(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand, NetherReactorBlockEntity netherReactor) {
        Vec3 p = pos.m_252807_();
        double d = 0.3;
        level.m_8767_((ParticleOptions)RediscoveredParticles.NETHER_REACTOR_GROWTH, p.f_82479_, p.f_82480_ - d, p.f_82481_, 10, d, d, d, 0.001);
    }
}

