/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;

public class RediscoveredUtil {
    public static final Codec<Float> NON_NEGATIVE_FLOAT = RediscoveredUtil.floatRangeWithMessage(0.0f, Float.MAX_VALUE, f -> "Value must be positive: " + f);

    private static Codec<Float> floatRangeWithMessage(float min, float max, Function<Float, String> errorMessage) {
        return ExtraCodecs.m_264370_((Codec)Codec.FLOAT, f -> f.compareTo(Float.valueOf(min)) >= 0 && f.compareTo(Float.valueOf(max)) <= 0 ? DataResult.success((Object)f) : DataResult.error(() -> (String)errorMessage.apply((Float)f)));
    }

    public static <T> Optional<Holder<T>> getRandom(ResourceKey<Registry<T>> registry, TagKey<T> tag, RegistryAccess registryAccess, RandomSource rand) {
        return registryAccess.m_175515_(registry).m_203431_(tag).flatMap(t -> t.m_213653_(rand));
    }

    public static Optional<Holder<Block>> getRandomBlock(TagKey<Block> tag, ServerLevelAccessor level, RandomSource rand) {
        return RediscoveredUtil.getRandom(Registries.f_256747_, tag, level.m_9598_(), rand);
    }

    public static Optional<Holder<Item>> getRandomItem(TagKey<Item> tag, ServerLevelAccessor level, RandomSource rand) {
        return RediscoveredUtil.getRandom(Registries.f_256913_, tag, level.m_9598_(), rand);
    }
}

