/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.block.RediscoveredDispenserBehavior;
import com.legacy.rediscovered.client.RediscoveredClientEvents;
import com.legacy.rediscovered.client.RediscoveredResourcePackHandler;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.compat.everycompat.EveryCompatModule;
import com.legacy.rediscovered.event.RediscoveredEvents;
import com.legacy.rediscovered.network.PacketHandler;
import com.legacy.rediscovered.registry.RediscoveredArmorTrims;
import com.legacy.rediscovered.registry.RediscoveredAttributes;
import com.legacy.rediscovered.registry.RediscoveredBiomeModifiers;
import com.legacy.rediscovered.registry.RediscoveredBiomes;
import com.legacy.rediscovered.registry.RediscoveredDamageTypes;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredFeatures;
import com.legacy.rediscovered.registry.RediscoveredLootModifiers;
import com.legacy.rediscovered.registry.RediscoveredPaintings;
import com.legacy.rediscovered.registry.RediscoveredPoiTypes;
import com.legacy.rediscovered.registry.RediscoveredPoolElementTypes;
import com.legacy.rediscovered.registry.RediscoveredProcessorLists;
import com.legacy.rediscovered.registry.RediscoveredRecipeSerializers;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rediscovered")
public class RediscoveredMod {
    public static final String MODID = "rediscovered";
    public static final Logger LOGGER = LogManager.getLogger((String)"ModdingLegacy/rediscovered");

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    public static String find(String key) {
        return new String("rediscovered:" + key);
    }

    public RediscoveredMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)RediscoveredConfig.WORLD_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)RediscoveredConfig.CLIENT_SPEC);
            modBus.register(RediscoveredClientEvents.ModEvents.class);
            modBus.addListener(RediscoveredResourcePackHandler::packRegistry);
            RediscoveredRenderType.init(modBus);
            forgeBus.register(RediscoveredClientEvents.ForgeEvents.class);
        });
        RediscoveredStructures.init();
        RediscoveredDimensions.init();
        RegistrarHandler.registerHandlers((String)MODID, (IEventBus)modBus, (RegistrarHandler[])new RegistrarHandler[]{RediscoveredFeatures.Configured.HANDLER, RediscoveredFeatures.Placed.HANDLER, RediscoveredBiomes.HANDLER, RediscoveredBiomeModifiers.HANDLER, RediscoveredPoiTypes.HANDLER, RediscoveredProcessorLists.HANDLER, RediscoveredPoolElementTypes.HANDLER, RediscoveredArmorTrims.PATTERN_HANDLER, RediscoveredArmorTrims.MATERIAL_HANDLER, RediscoveredAttributes.HANDLER, RediscoveredRecipeSerializers.HANDLER, RediscoveredDamageTypes.HANDLER, RediscoveredPaintings.HANDLER, RediscoveredLootModifiers.HANDLER});
        modBus.addListener(RediscoveredEntityTypes::onAttributesRegistered);
        modBus.addListener(EventPriority.LOWEST, RediscoveredEntityTypes::registerPlacements);
        modBus.addListener(EventPriority.NORMAL, RediscoveredEntityTypes::registerPlacementOverrides);
        modBus.addListener(RediscoveredMod::commonInit);
        forgeBus.register(RediscoveredEvents.class);
        if (ModList.get().isLoaded("everycomp")) {
            EveryCompatModule.init();
        }
    }

    private static void commonInit(FMLCommonSetupEvent event) {
        PacketHandler.register();
        event.enqueueWork(() -> {
            RediscoveredDispenserBehavior.init();
            RediscoveredEffects.registerPotions();
        });
    }
}

