/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered;

import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.structure_gel.api.config.ConfigBuilder;
import com.legacy.structure_gel.api.config.ConfigValueWrapper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class RediscoveredConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec WORLD_SPEC;
    public static final ClientConfig CLIENT;
    public static final WorldConfig WORLD;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(WorldConfig::new);
        WORLD = (WorldConfig)pair.getLeft();
        WORLD_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static class ClientConfig {
        private final ForgeConfigSpec.ConfigValue<Boolean> customSkylandsClouds;
        private final ForgeConfigSpec.ConfigValue<Boolean> overrideVanillaClouds;
        private final ForgeConfigSpec.ConfigValue<Integer> screenShakeIntensity;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowAprilFools;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Visuals");
            this.customSkylandsClouds = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"extra_skylands_clouds", (String)"Replaces the default clouds in the Skylands with more plentiful, and fluffier ones.", (boolean)true);
            this.overrideVanillaClouds = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"override_vanilla_clouds", (String)"Replaces the default cloud rendering with the fluffy clouds found in the Skylands.", (boolean)false);
            this.screenShakeIntensity = ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"screen_shake_intensity", (String)"The intensity percentage of the screen shake caused by various things in the mod. Can be disabled if set to 0", (int)100, (int)0, (int)100);
            builder.pop();
            builder.push("Holiday");
            this.allowAprilFools = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"allow_april_fools", (String)"Allows April Fool's day effects to appear on April 1st", (boolean)true);
            builder.pop();
        }

        public boolean customSkylandsClouds() {
            return (Boolean)this.customSkylandsClouds.get();
        }

        public boolean overrideVanillaClouds() {
            return (Boolean)this.overrideVanillaClouds.get();
        }

        public int screenShakeIntensity() {
            return (Integer)this.screenShakeIntensity.get();
        }

        public boolean allowAprilFools() {
            return (Boolean)this.allowAprilFools.get();
        }
    }

    public static class WorldConfig {
        private final ConfigValueWrapper<Integer, Float> zombieHorseSiegePercentage;
        private final ConfigValueWrapper<Integer, Float> zombieHorseVillagePercentage;
        private final ConfigValueWrapper<Integer, Float> taggedPlateArmorPercentage;
        private final ForgeConfigSpec.ConfigValue<Integer> maxGearDistance;
        private final ForgeConfigSpec.ConfigValue<Boolean> hatchableRedDragon;
        private final ForgeConfigSpec.ConfigValue<Boolean> redDragonStamina;

        public WorldConfig(ForgeConfigSpec.Builder builder) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            builder.push("Vanilla Additions");
            this.zombieHorseSiegePercentage = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"zombie_horses_siege_spawn_percentage", (String)"Chance that a Zombie in a village siege will spawn mounting a Zombie Horse.", (int)30, (int)0, (int)100), i -> Float.valueOf((float)i.intValue() / 100.0f), (IEventBus)bus, (String)"rediscovered");
            this.zombieHorseVillagePercentage = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"zombie_horses_village_replace_percentage", (String)("Chance that mobs in the `#" + RediscoveredTags.Entities.BECOMES_ZOMBIE_HORSE_IN_ZOMBIE_VILLAGE.f_203868_() + "` tag will become a Zombie Horse when spawned in a zombie village."), (int)70, (int)0, (int)100), i -> Float.valueOf((float)i.intValue() / 100.0f), (IEventBus)bus, (String)"rediscovered");
            this.taggedPlateArmorPercentage = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"tagged_plate_armor_percentage", (String)("Chance mobs in the `#" + RediscoveredTags.Entities.PLATE_ARMOR_SPAWNS.f_203868_() + "` tag will spawn with plate armor."), (int)5, (int)0, (int)100), i -> Float.valueOf((float)i.intValue() / 100.0f), (IEventBus)bus, (String)"rediscovered");
            builder.pop();
            builder.push("Tweaks");
            this.maxGearDistance = ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"max_gear_distance", (String)"The maximum distance gears can be powered from a source. Set to -1 for unlimited distance.", (int)100, (int)-1, (int)300);
            this.hatchableRedDragon = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"hatchable_red_dragon_egg", (String)"Allow hatching of Red Dragons.", (boolean)true);
            this.redDragonStamina = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"red_dragon_stamina", (String)"Gives tamed Red Dragons stamina. This limits how far they can fly without touching the ground.\nA bar will be displayed above the rider's hotbar to display how much stamina the dragon has left.", (boolean)true);
            builder.pop();
        }

        public float zombieHorseSiegePercentage() {
            return ((Float)this.zombieHorseSiegePercentage.get()).floatValue();
        }

        public float zombieHorseVillagePercentage() {
            return ((Float)this.zombieHorseVillagePercentage.get()).floatValue();
        }

        public float taggedPlateArmorPercentage() {
            return ((Float)this.taggedPlateArmorPercentage.get()).floatValue();
        }

        public int maxGearDistance() {
            return (Integer)this.maxGearDistance.get();
        }

        public boolean hatchableRedDragon() {
            return (Boolean)this.hatchableRedDragon.get();
        }

        public boolean redDragonStamina() {
            return (Boolean)this.redDragonStamina.get();
        }
    }

    public static class CommonConfig {
        public CommonConfig(ForgeConfigSpec.Builder builder) {
        }
    }
}

