/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.mixins;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.entities.TileTicker;
import noobanidus.mods.lootr.config.ConfigManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RandomizableContainerBlockEntity.class})
public class MixinRandomizableContainerBlockEntity {
    @Inject(method={"setLootTable(Lnet/minecraft/resources/ResourceLocation;J)V"}, at={@At(value="RETURN")})
    private void lootrOnSetLootTable(ResourceLocation p_59627_, long p_59628_, CallbackInfo ci) {
        if (((Boolean)ConfigManager.DISABLE.get()).booleanValue() || !((Boolean)ConfigManager.AGGRESSIVE_MODE.get()).booleanValue()) {
            return;
        }
        RandomizableContainerBlockEntity incoming = (RandomizableContainerBlockEntity)this;
        if (incoming instanceof ILootBlockEntity) {
            return;
        }
        Level level = incoming.m_58904_();
        if (level == null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            level = server.m_129783_();
            LootrAPI.LOG.error("Block entity at {} had its loot table set before its level was set. It's not possible to determine its dimension, so presuming the overworld.", (Object)incoming.m_58899_());
        }
        if (level.m_5776_()) {
            return;
        }
        if (((Boolean)ConfigManager.CHECK_WORLD_BORDER.get()).booleanValue() && !level.m_6857_().m_61937_(incoming.m_58899_())) {
            return;
        }
        TileTicker.addEntry(incoming, level, incoming.m_58899_());
    }
}

