/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.common;

import com.illusivesoulworks.bedspreads.common.BedspreadsRegistry;
import com.illusivesoulworks.bedspreads.common.DecoratedBedItem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DecoratedBedBlockEntity
extends BlockEntity {
    private ItemStack bed = ItemStack.f_41583_;
    private ItemStack banner = ItemStack.f_41583_;
    private DyeColor bannerColor = DyeColor.WHITE;
    private ListTag patterns;
    private boolean patternDataSet;
    private List<Pair<Holder<BannerPattern>, DyeColor>> patternList;

    public DecoratedBedBlockEntity(BlockPos pos, BlockState state) {
        super(BedspreadsRegistry.DECORATED_BED_BLOCK_ENTITY.get(), pos, state);
    }

    public void loadFromItemStack(ItemStack stack) {
        CompoundTag bannernbt;
        this.patterns = null;
        CompoundTag nbttagcompound = stack.m_41737_("BlockEntityTag");
        if (nbttagcompound != null) {
            this.bed = ItemStack.m_41712_((CompoundTag)nbttagcompound.m_128469_("BedStack"));
            this.banner = ItemStack.m_41712_((CompoundTag)nbttagcompound.m_128469_("BannerStack"));
            if (!this.banner.m_41619_()) {
                this.bannerColor = DecoratedBedItem.getBannerColor(this.banner);
            }
        }
        if ((bannernbt = this.banner.m_41737_("BlockEntityTag")) != null && bannernbt.m_128425_("Patterns", 9)) {
            this.patterns = bannernbt.m_128437_("Patterns", 10).m_6426_();
        }
        this.patternList = null;
        this.patternDataSet = true;
    }

    protected void m_183515_(@Nonnull CompoundTag pTag) {
        if (!this.bed.m_41619_()) {
            pTag.m_128365_("BedStack", (Tag)this.bed.m_41739_(new CompoundTag()));
        }
        if (!this.banner.m_41619_()) {
            pTag.m_128365_("BannerStack", (Tag)this.banner.m_41739_(new CompoundTag()));
        }
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        CompoundTag bannernbt;
        super.m_142466_(compound);
        this.bed = compound.m_128441_("BedStack") ? ItemStack.m_41712_((CompoundTag)compound.m_128469_("BedStack")) : ItemStack.f_41583_;
        ItemStack itemStack = this.banner = compound.m_128441_("BannerStack") ? ItemStack.m_41712_((CompoundTag)compound.m_128469_("BannerStack")) : ItemStack.f_41583_;
        if (!this.banner.m_41619_()) {
            this.bannerColor = DecoratedBedItem.getBannerColor(this.banner);
        }
        this.patterns = (bannernbt = this.banner.m_41737_("BlockEntityTag")) != null ? bannernbt.m_128437_("Patterns", 10).m_6426_() : null;
        this.patternList = null;
        this.patternDataSet = true;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public List<Pair<Holder<BannerPattern>, DyeColor>> getPatternList() {
        if (this.patternList == null && this.patternDataSet) {
            this.patternList = BannerBlockEntity.m_58484_((DyeColor)this.getBannerColor(), (ListTag)this.patterns);
        }
        return this.patternList;
    }

    public ItemStack getItem() {
        ItemStack itemstack = new ItemStack((ItemLike)BedspreadsRegistry.DECORATED_BED_ITEM.get());
        CompoundTag compound = itemstack.m_41698_("BlockEntityTag");
        if (!this.bed.m_41619_()) {
            compound.m_128365_("BedStack", (Tag)this.bed.m_41739_(new CompoundTag()));
        }
        if (!this.banner.m_41619_()) {
            compound.m_128365_("BannerStack", (Tag)this.banner.m_41739_(new CompoundTag()));
        }
        return itemstack;
    }

    public DyeColor getBannerColor() {
        return this.bannerColor;
    }

    public ItemStack getBanner() {
        return this.banner;
    }
}

