/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.forge.resource;

import io.github.mortuusars.scholar.Scholar;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class ProcessedBuiltInResourcePackTracker {
    public static Set<String> getPacks() {
        HashSet<String> savedPacks = new HashSet<String>();
        ProcessedBuiltInResourcePackTracker.getStateFile().ifPresent(file -> {
            if (!file.exists()) {
                return;
            }
            try {
                CompoundTag data = NbtIo.m_128937_((File)file);
                ListTag values = data.m_128437_("packs", 8);
                for (int i = 0; i < values.size(); ++i) {
                    savedPacks.add(values.m_128778_(i));
                }
            }
            catch (IOException e) {
                Scholar.LOGGER.warn("[Scholar Default Built-in Resource Packs] Could not read {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        });
        return savedPacks;
    }

    public static void savePacks(Set<String> processedPacks) {
        ProcessedBuiltInResourcePackTracker.getStateFile().ifPresent(file -> {
            try {
                ListTag values = new ListTag();
                for (String id : processedPacks) {
                    values.add((Object)StringTag.m_129297_((String)id));
                }
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("packs", (Tag)values);
                NbtIo.m_128944_((CompoundTag)nbt, (File)file);
            }
            catch (IOException e) {
                Scholar.LOGGER.warn("[Fabric Resource Loader] Could not write to {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        });
    }

    private static Optional<File> getStateFile() {
        try {
            File dataFolder = Minecraft.m_91087_().f_91069_.toPath().resolve("data").toFile();
            if (!dataFolder.exists() && !dataFolder.mkdirs()) {
                Scholar.LOGGER.warn("[Scholar Default Built-in Resource Packs] Could not create data directory: {}", (Object)dataFolder.getAbsolutePath());
            }
            return Optional.of(new File(dataFolder, "scholar_loaded_built_in_resource_packs.dat"));
        }
        catch (Exception e) {
            Scholar.LOGGER.warn("[Scholar Default Built-in Resource Packs] Could not create state file: ", (Throwable)e);
            return Optional.empty();
        }
    }
}

