/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox.display;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Formatting;
import io.github.mortuusars.scholar.client.util.Pos2i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class FormattingToolbar {
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/formatting_toolbar.png");
    public static final Map<Character, String> HOTKEYS = new HashMap<Character, String>();
    protected final TextBox textBox;
    protected Positioner positioner = Positioner.ABOVE_SELECTION;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected boolean visible = true;
    protected boolean shouldUpdate = true;
    protected final List<FormattingButton> buttons = new ArrayList<FormattingButton>();

    public FormattingToolbar(TextBox textBox) {
        this.textBox = textBox;
        this.setup();
    }

    protected void setup() {
        this.buttons.clear();
        int x = 0;
        this.buttons.add(new FormattingButton(Formatting.Format.BOLD, new Rect2i(x, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.ITALIC, new Rect2i(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.UNDERLINE, new Rect2i(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.STRIKETHROUGH, new Rect2i(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.OBFUSCATED, new Rect2i(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.RESET, new Rect2i((x += 12) - 8, -13, 19, 28), new Pos2i(x, 0)));
        x += 11;
        for (Formatting.Color color : Arrays.stream(Formatting.Color.values()).limit(8L).toList()) {
            this.buttons.add(new FormattingButton(color, new Rect2i(x, 0, 7, 7), new Pos2i(x + 8, 0)));
            x += 6;
        }
        ++x;
        for (Formatting.Color color : Arrays.stream(Formatting.Color.values()).skip(8L).toList()) {
            this.buttons.add(new FormattingButton(color, new Rect2i(x - 49, 6, 7, 9), new Pos2i(x + 8, 0)));
            x += 6;
        }
        this.width = this.buttons.stream().mapToInt(button -> button.area().m_110085_() + button.area.m_110090_()).max().orElse(0);
        this.height = this.buttons.stream().mapToInt(button -> button.area().m_110086_() + button.area.m_110091_()).max().orElse(0);
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public Positioner getPositioner() {
        return this.positioner;
    }

    public FormattingToolbar setPositioner(Positioner positioner) {
        this.positioner = positioner;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public FormattingToolbar setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean shouldUpdate() {
        return this.shouldUpdate;
    }

    public void scheduleUpdate() {
        this.shouldUpdate = true;
    }

    public void update() {
        Pos2i pos = this.positioner.position(this, this.getTextBox());
        this.x = pos.x;
        this.y = pos.y;
        for (FormattingButton button : this.buttons) {
            if (button.formatting() == Formatting.RESET) continue;
            button.highlighted = this.getTextBox().getEditor().getSelectedSpan().stream().allMatch(c -> c.hasFormatting(button.formatting()));
        }
        this.shouldUpdate = false;
    }

    public boolean shouldShow() {
        return this.getTextBox().m_93696_() && this.getTextBox().getEditor().isSelecting();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible() || !this.shouldShow()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        FormattingButton hoveredButton = null;
        for (FormattingButton button : this.buttons) {
            int vOffset = 0;
            if (button.disabled()) {
                vOffset = button.area.m_110091_() * 2;
            } else if (button.highlighted()) {
                vOffset = button.area.m_110091_();
            }
            if (hoveredButton == null && button.isHovering(mouseX - this.x, mouseY - this.y)) {
                hoveredButton = button;
                if (!button.disabled()) {
                    vOffset = button.area.m_110091_();
                }
            }
            guiGraphics.m_280218_(TEXTURE, this.x + button.area.m_110085_(), this.y + button.area.m_110086_(), button.uv.x, button.uv.y + vOffset, button.area.m_110090_(), button.area.m_110091_());
        }
        if (hoveredButton != null) {
            MutableComponent component = Component.m_237115_((String)("gui.scholar.formatting." + hoveredButton.formatting.getName())).m_130946_(" \u00a78" + HOTKEYS.getOrDefault(Character.valueOf(hoveredButton.formatting.getChar()), ""));
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)component, mouseX, mouseY + 20);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isVisible() && this.shouldShow() && button == 0) {
            for (FormattingButton formattingButton : this.buttons) {
                if (!formattingButton.isHovering((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y))) continue;
                this.getTextBox().getEditor().applyFormatting(Formatting.of(formattingButton.formatting()));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f, (float)0.3f));
                return true;
            }
        }
        return false;
    }

    static {
        HOTKEYS.put(Character.valueOf(Formatting.Format.OBFUSCATED.getChar()), "Ctrl+K");
        HOTKEYS.put(Character.valueOf(Formatting.Format.BOLD.getChar()), "Ctrl+L");
        HOTKEYS.put(Character.valueOf(Formatting.Format.STRIKETHROUGH.getChar()), "Ctrl+M");
        HOTKEYS.put(Character.valueOf(Formatting.Format.UNDERLINE.getChar()), "Ctrl+N");
        HOTKEYS.put(Character.valueOf(Formatting.Format.ITALIC.getChar()), "Ctrl+O");
        HOTKEYS.put(Character.valueOf(Formatting.RESET.getChar()), "Ctrl+R");
        HOTKEYS.put(Character.valueOf(Formatting.Color.BLACK.getChar()), "Ctrl+1");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_BLUE.getChar()), "Ctrl+2");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_GREEN.getChar()), "Ctrl+3");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_AQUA.getChar()), "Ctrl+4");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_RED.getChar()), "Ctrl+5");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_PURPLE.getChar()), "Ctrl+6");
        HOTKEYS.put(Character.valueOf(Formatting.Color.GOLD.getChar()), "Ctrl+7");
        HOTKEYS.put(Character.valueOf(Formatting.Color.GRAY.getChar()), "Ctrl+8");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_GRAY.getChar()), "Ctrl+Shift+1");
        HOTKEYS.put(Character.valueOf(Formatting.Color.BLUE.getChar()), "Ctrl+Shift+2");
        HOTKEYS.put(Character.valueOf(Formatting.Color.GREEN.getChar()), "Ctrl+Shift+3");
        HOTKEYS.put(Character.valueOf(Formatting.Color.AQUA.getChar()), "Ctrl+Shift+4");
        HOTKEYS.put(Character.valueOf(Formatting.Color.RED.getChar()), "Ctrl+Shift+5");
        HOTKEYS.put(Character.valueOf(Formatting.Color.LIGHT_PURPLE.getChar()), "Ctrl+Shift+6");
        HOTKEYS.put(Character.valueOf(Formatting.Color.YELLOW.getChar()), "Ctrl+Shift+7");
        HOTKEYS.put(Character.valueOf(Formatting.Color.WHITE.getChar()), "Ctrl+Shift+8");
    }

    public static interface Positioner {
        public static final Positioner ABOVE_SELECTION = (toolbar, textBox) -> {
            int selectionStartY = textBox.getDisplayCache().getSelection().stream().mapToInt(Rect2i::m_110086_).min().orElse(0);
            int x = textBox.m_252754_() + HorizontalAlignment.CENTER.align(textBox.m_5711_(), toolbar.getWidth());
            int n = textBox.m_252907_() + selectionStartY;
            Objects.requireNonNull(textBox.getFont());
            int y = n - 9 - toolbar.getHeight();
            return new Pos2i(x, y);
        };

        public Pos2i position(FormattingToolbar var1, TextBox var2);
    }

    public static class FormattingButton {
        private final Formatting.Type formatting;
        private final Rect2i area;
        private final Pos2i uv;
        private boolean disabled;
        private boolean highlighted;

        public FormattingButton(Formatting.Type formatting, Rect2i area, Pos2i uv) {
            this.formatting = formatting;
            this.area = area;
            this.uv = uv;
        }

        public Formatting.Type formatting() {
            return this.formatting;
        }

        public Rect2i area() {
            return this.area;
        }

        public Pos2i uv() {
            return this.uv;
        }

        public boolean disabled() {
            return this.disabled;
        }

        public boolean highlighted() {
            return this.highlighted;
        }

        public boolean isHovering(int mouseX, int mouseY) {
            return mouseX >= this.area.m_110085_() && mouseX < this.area.m_110085_() + this.area.m_110090_() && mouseY >= this.area.m_110086_() && mouseY < this.area.m_110086_() + this.area.m_110091_();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FormattingButton that = (FormattingButton)obj;
            return Objects.equals(this.formatting, that.formatting) && Objects.equals(this.area, that.area) && Objects.equals(this.uv, that.uv) && this.disabled == that.disabled && this.highlighted == that.highlighted;
        }

        public int hashCode() {
            return Objects.hash(this.formatting, this.area, this.uv, this.disabled, this.highlighted);
        }

        public String toString() {
            return "FormattingButton[formatting=" + String.valueOf(this.formatting) + ", area=" + String.valueOf(this.area) + ", uv=" + String.valueOf(this.uv) + ", disabled=" + this.disabled + ", highlighted=" + this.highlighted + "]";
        }
    }
}

