/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.view;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import org.jetbrains.annotations.NotNull;

public interface BookViewAccess {
    public static final BookViewAccess EMPTY = new BookViewAccess(){

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public FormattedText getPageRaw(int i) {
            return FormattedText.f_130760_;
        }
    };

    public int getPageCount();

    public FormattedText getPageRaw(int var1);

    default public FormattedText getPage(int pageIndex) {
        return pageIndex >= 0 && pageIndex < this.getPageCount() ? this.getPageRaw(pageIndex) : FormattedText.f_130760_;
    }

    public static BookViewAccess fromItem(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof WrittenBookItem) {
            return new WrittenBookAccess(itemStack);
        }
        if (itemStack.m_41720_() instanceof WritableBookItem) {
            return new WritableBookAccess(itemStack);
        }
        return EMPTY;
    }

    public static List<String> loadPages(CompoundTag compoundTag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        BookViewAccess.loadPages(compoundTag, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void loadPages(CompoundTag compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        ListTag listTag = compoundTag.m_128437_("pages", 8).m_6426_();
        if (Minecraft.m_91087_().m_167974_() && compoundTag.m_128425_("filtered_pages", 10)) {
            CompoundTag compoundTag2 = compoundTag.m_128469_("filtered_pages");
            intFunction = ix -> {
                String string = String.valueOf(ix);
                return compoundTag2.m_128441_(string) ? compoundTag2.m_128461_(string) : listTag.m_128778_(ix);
            };
        } else {
            Objects.requireNonNull(listTag);
            intFunction = arg_0 -> ((ListTag)listTag).m_128778_(arg_0);
        }
        for (int i = 0; i < listTag.size(); ++i) {
            consumer.accept(intFunction.apply(i));
        }
    }

    public static class WrittenBookAccess
    implements BookViewAccess {
        private final List<String> pages;

        public WrittenBookAccess(ItemStack itemStack) {
            this.pages = WrittenBookAccess.readPages(itemStack);
        }

        private static List<String> readPages(ItemStack itemStack) {
            CompoundTag compoundTag = itemStack.m_41783_();
            return WrittenBookItem.m_43471_((CompoundTag)compoundTag) ? BookViewAccess.loadPages(compoundTag) : ImmutableList.of((Object)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"book.invalid.tag").m_130940_(ChatFormatting.DARK_RED)));
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        @NotNull
        public FormattedText getPageRaw(int i) {
            String string = this.pages.get(i);
            try {
                MutableComponent formattedText = Component.Serializer.m_130701_((String)string);
                if (formattedText != null) {
                    return formattedText;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return FormattedText.m_130775_((String)string);
        }
    }

    public static class WritableBookAccess
    implements BookViewAccess {
        private final List<String> pages;

        public WritableBookAccess(ItemStack itemStack) {
            this.pages = WritableBookAccess.readPages(itemStack);
        }

        private static List<String> readPages(ItemStack itemStack) {
            CompoundTag compoundTag = itemStack.m_41783_();
            return compoundTag != null ? BookViewAccess.loadPages(compoundTag) : ImmutableList.of();
        }

        @Override
        public int getPageCount() {
            return 100;
        }

        @Override
        public FormattedText getPageRaw(int i) {
            return i >= this.pages.size() ? FormattedText.f_130760_ : FormattedText.m_130775_((String)this.pages.get(i));
        }
    }
}

