/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.ScholarClient;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import java.util.Objects;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class SpreadBookScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/book.png");
    public static final int BOOK_WIDTH = 295;
    public static final int BOOK_HEIGHT = 180;
    public static final int TEXT_LEFT_X = 22;
    public static final int TEXT_RIGHT_X = 159;
    public static final int TEXT_Y = 21;
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_HEIGHT = 128;
    @NotNull
    protected final Minecraft minecraft = Minecraft.m_91087_();
    @NotNull
    protected final LocalPlayer player;
    protected int bookColor;
    protected int textColor;
    protected int pageNumbersColor;
    protected int selectionColor;
    protected int selectionUnfocusedColor;
    protected int leftPos;
    protected int topPos;
    protected Button prevPageButton;
    protected Button nextPageButton;
    protected int currentSpread;

    public SpreadBookScreen(int bookColor) {
        super(GameNarrator.f_93310_);
        this.player = Objects.requireNonNull(this.minecraft.f_91074_);
        this.bookColor = bookColor;
        this.textColor = Config.Client.getColor(Config.Client.TEXT_COLOR);
        this.pageNumbersColor = Config.Client.getColor(Config.Client.PAGE_NUMBERS_COLOR);
        this.selectionColor = Config.Client.getColor(Config.Client.SELECTION_COLOR);
        this.selectionUnfocusedColor = Config.Client.getColor(Config.Client.SELECTION_UNFOCUSED_COLOR);
    }

    public boolean m_7043_() {
        return (Boolean)Config.Client.SCREEN_PAUSE.get();
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 295) / 2;
        this.topPos = (this.f_96544_ - 180) / 2;
        this.createWidgets();
    }

    protected void createWidgets() {
        this.createPrevPageButton();
        this.createNextPageButton();
        this.createBottomButtons();
    }

    protected void createNextPageButton() {
        ImageButton nextPageButton = new ImageButton(this.leftPos + 270, this.topPos + 156, 13, 15, 308, 0, 15, TEXTURE, 512, 512, button -> this.pageForward());
        nextPageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"spectatorMenu.next_page")));
        this.nextPageButton = (Button)this.m_142416_((GuiEventListener)nextPageButton);
    }

    protected void createPrevPageButton() {
        ImageButton prevPageButton = new ImageButton(this.leftPos + 12, this.topPos + 156, 13, 15, 295, 0, 15, TEXTURE, 512, 512, button -> this.pageBack());
        prevPageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"spectatorMenu.previous_page")));
        this.prevPageButton = (Button)this.m_142416_((GuiEventListener)prevPageButton);
    }

    protected void createBottomButtons() {
        if (((Boolean)Config.Client.SHOW_DONE_BUTTON.get()).booleanValue()) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 60, this.topPos + 180 + 12, 120, 20).m_253136_());
        }
    }

    protected void updateButtonVisibility() {
        this.prevPageButton.f_93624_ = this.currentSpread > 0;
        this.nextPageButton.f_93624_ = this.currentSpread < this.getSpreadCount() - 1;
    }

    protected void toggleBookTools() {
        boolean currentValue = (Boolean)Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.get();
        Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.set((Object)(!currentValue ? 1 : 0));
        Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.save();
    }

    public boolean isToolsVisible() {
        return (Boolean)Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.get();
    }

    public int getPageCount() {
        return 100;
    }

    public int getSpreadCount() {
        return (int)Math.ceil((double)this.getPageCount() / 2.0);
    }

    protected boolean pageBack() {
        if (this.currentSpread > 0) {
            --this.currentSpread;
            this.playPageTurnSound(0.8f);
            return true;
        }
        return false;
    }

    protected boolean pageForward() {
        if (this.currentSpread < this.getSpreadCount() - 1) {
            ++this.currentSpread;
            this.playPageTurnSound(1.0f);
            return true;
        }
        return false;
    }

    protected void renderBook(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.m_280411_(TEXTURE, this.leftPos, this.topPos, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512));
        guiGraphics.m_280411_(TEXTURE, this.leftPos, this.topPos, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
    }

    protected void renderPageNumbers(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread) {
        this.renderLeftPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, this.pageNumbersColor);
        this.renderRightPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, this.pageNumbersColor);
    }

    protected void renderLeftPageNumber(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        String leftPageNumber = Integer.toString(currentSpread * 2 + 1);
        guiGraphics.m_280056_(this.f_96547_, leftPageNumber, this.leftPos + 69 + (8 - this.f_96547_.m_92895_(leftPageNumber) / 2), this.topPos + 157, color, false);
    }

    protected void renderRightPageNumber(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        String rightPageNumber = Integer.toString(currentSpread * 2 + 2);
        guiGraphics.m_280056_(this.f_96547_, rightPageNumber, this.leftPos + 208 + (8 - this.f_96547_.m_92895_(rightPageNumber) / 2), this.topPos + 157, color, false);
    }

    protected void renderTools(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (ScholarClient.KeyMappings.toggleBookTools.m_90832_(keyCode, scanCode)) {
            this.toggleBookTools();
            return true;
        }
        if (!(this.m_7222_() instanceof TextBox)) {
            if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
                this.m_7379_();
                return true;
            }
            if (keyCode == 263 || keyCode == 266 || Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode)) {
                this.pageBack();
                return true;
            }
            if (keyCode == 262 || keyCode == 267 || Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode)) {
                this.pageForward();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (mouseX -= (double)this.leftPos) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)this.topPos) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    protected boolean isHoveringOverRightPageNumber(double mouseX, double mouseY) {
        return this.isHovering(206, 157, 17, 7, mouseX, mouseY);
    }

    protected boolean isHoveringOverLeftPageNumber(double mouseX, double mouseY) {
        return this.isHovering(66, 157, 17, 7, mouseX, mouseY);
    }

    protected boolean isLeftPage(int pageIndex) {
        return pageIndex % 2 == 0;
    }

    protected boolean isRightPage(int pageIndex) {
        return pageIndex % 2 == 1;
    }

    protected void playButtonClickSound(float volume, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)pitch, (float)volume));
    }

    protected void playButtonClickSound(float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)pitch, (float)0.3f));
    }

    protected void playButtonClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f, (float)0.3f));
    }

    protected void playPageTurnSound(float volume, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11713_, (float)pitch, (float)volume));
    }

    protected void playPageTurnSound(float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11713_, (float)pitch, (float)1.0f));
    }

    protected void playPageTurnSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11713_, (float)1.0f, (float)1.0f));
    }
}

