/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.chiseled_bookshelf;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.client.chiseled_bookshelf.BookshelfDefaultColors;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookshelfColors {
    public static Map<ResourceLocation, BookshelfDefaultColors> DEFAULT_SLOT_COLORS = Collections.emptyMap();
    public static Map<ResourceLocation, Integer> ITEM_COLORS = Collections.emptyMap();

    public static int getSlotTintColor(BlockState state, @Nullable BlockAndTintGetter blockGetter, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (blockGetter == null || pos == null || tintIndex < 0 || tintIndex > 5 || !((blockEntity = blockGetter.m_7702_(pos)) instanceof ChiseledBookShelfBlockEntity)) {
            return ChiseledBookshelfColors.getDefaultTintColorForSlot(state, tintIndex);
        }
        ChiseledBookShelfBlockEntity blockEntity2 = (ChiseledBookShelfBlockEntity)blockEntity;
        ItemStack stackInSlot = blockEntity2.m_8020_(tintIndex);
        if (stackInSlot.m_41619_()) {
            return -1;
        }
        if (stackInSlot.m_41720_() instanceof WrittenBookItem || stackInSlot.m_41720_() instanceof WritableBookItem) {
            return BookColor.of(stackInSlot);
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stackInSlot.m_41720_());
        return ITEM_COLORS.getOrDefault(itemId, ChiseledBookshelfColors.getDefaultTintColorForSlot(state, tintIndex));
    }

    public static int getDefaultTintColorForSlot(BlockState state, int slot) {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        return DEFAULT_SLOT_COLORS.getOrDefault(blockId, BookshelfDefaultColors.VANILLA).getDefaultTintForSlot(slot);
    }

    public static void setBookshelfRenderLayer(BiConsumer<Block, RenderType> consumer) {
        Scholar.LOGGER.info("Scholar is setting RenderType of all 'ChiseledBookShelfBlock's to 'cutout' so the books could have proper colors in bookshelves.");
        Scholar.LOGGER.info("If Chiseled Bookshelves do not look correctly, please report to the Scholar github.");
        BuiltInRegistries.f_256975_.m_123024_().filter(bl -> bl instanceof ChiseledBookShelfBlock).forEach(bl -> consumer.accept((Block)bl, RenderType.m_110463_()));
    }

    public static void registerBookshelfBlockColors(BiConsumer<BlockColor, Block> consumer) {
        Scholar.LOGGER.info("Scholar is registering 'BlockColor' (tints) for all 'ChiseledBookShelfBlock's, so the books could have proper colors in bookshelves.");
        Scholar.LOGGER.info("If Chiseled Bookshelves do not look correctly, please report to the Scholar github.");
        BuiltInRegistries.f_256975_.m_123024_().filter(bl -> bl instanceof ChiseledBookShelfBlock).forEach(bl -> consumer.accept(ChiseledBookshelfColors::getSlotTintColor, (Block)bl));
    }
}

