/*
 * Decompiled with CFR 0.152.
 */
package com.vanyabaou.exhaustionoptions;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="exhaustionoptions", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EOConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.DoubleValue GLOBAL_MULTIPLIER = BUILDER.comment("Global exhaustion multiplier").defineInRange("globalMultiplier", 1.5, 0.0, 10.0);
    public static float globalMultiplier;
    private static final ForgeConfigSpec.DoubleValue DAMAGETYPE_MULTIPLIER;
    public static float damageTypeMultiplier;
    private static final ForgeConfigSpec.DoubleValue JUMP_MULTIPLIER;
    public static float jumpMultiplier;
    private static final ForgeConfigSpec.DoubleValue SWIM_MULTIPLIER;
    public static float swimMultiplier;
    private static final ForgeConfigSpec.DoubleValue UNDERWATER_WALK_MULTIPLIER;
    public static float underwaterWalkMultiplier;
    private static final ForgeConfigSpec.DoubleValue SHALLOW_WATER_WALK_MULTIPLIER;
    public static float shallowWaterWalkMultiplier;
    private static final ForgeConfigSpec.DoubleValue SPRINT_MULTIPLIER;
    public static float sprintMultiplier;
    private static final ForgeConfigSpec.DoubleValue BLOCK_MINING_MULTIPLIER;
    public static float blockMiningMultiplier;
    static final ForgeConfigSpec SPEC;

    static void uppdateValues() {
        globalMultiplier = ((Double)GLOBAL_MULTIPLIER.get()).floatValue();
        damageTypeMultiplier = ((Double)DAMAGETYPE_MULTIPLIER.get()).floatValue();
        jumpMultiplier = ((Double)JUMP_MULTIPLIER.get()).floatValue();
        swimMultiplier = ((Double)SWIM_MULTIPLIER.get()).floatValue();
        underwaterWalkMultiplier = ((Double)UNDERWATER_WALK_MULTIPLIER.get()).floatValue();
        shallowWaterWalkMultiplier = ((Double)SHALLOW_WATER_WALK_MULTIPLIER.get()).floatValue();
        sprintMultiplier = ((Double)SPRINT_MULTIPLIER.get()).floatValue();
        blockMiningMultiplier = ((Double)BLOCK_MINING_MULTIPLIER.get()).floatValue();
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        EOConfig.uppdateValues();
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        EOConfig.uppdateValues();
    }

    static {
        DAMAGETYPE_MULTIPLIER = BUILDER.comment("DamageSource exhaustion type multiplier").defineInRange("damageTypeMultiplier", 1.0, 0.0, 10.0);
        JUMP_MULTIPLIER = BUILDER.comment("Jump multiplier").defineInRange("jumpMultiplier", 1.0, 0.0, 10.0);
        SWIM_MULTIPLIER = BUILDER.comment("Swimming exhaustion multiplier").defineInRange("swimMultiplier", 1.0, 0.0, 10.0);
        UNDERWATER_WALK_MULTIPLIER = BUILDER.comment("Underwater walking exhaustion multiplier").defineInRange("underwaterWalkMultiplier", 1.0, 0.0, 10.0);
        SHALLOW_WATER_WALK_MULTIPLIER = BUILDER.comment("Shallow water walking exhaustion multiplier").defineInRange("shallowWaterWalkMultiplier", 1.0, 0.0, 10.0);
        SPRINT_MULTIPLIER = BUILDER.comment("Sprinting exhaustion multiplier").defineInRange("sprintMultiplier", 1.0, 0.0, 10.0);
        BLOCK_MINING_MULTIPLIER = BUILDER.comment("Block mining exhaustion multiplier").defineInRange("blockMiningMultiplier", 1.0, 0.0, 10.0);
        SPEC = BUILDER.build();
    }
}

