/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles.flowers;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.api.FlowerHUD;
import org.zeith.botanicadds.blocks.flowers.VibrantiaBlock;
import org.zeith.botanicadds.init.FlowersBA;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.internal.ManaBurst;

@FlowerHUD
public class Vibrantia
extends GeneratingFlowerBlockEntity
implements GameEventListener.Holder<VibrationSystem.Listener>,
VibrationSystem {
    protected int lastVibrationFrequency;
    protected boolean hasOvergrownSoil;
    protected int activeTicks;
    private VibrationSystem.Data vibrationData;
    private final VibrationSystem.Listener vibrationListener;
    private final VibrationSystem.User vibrationUser = this.createVibrationUser();

    public Vibrantia(BlockPos pos, BlockState state) {
        super(FlowersBA.VIBRANTIA_TYPE, pos, state);
        this.vibrationData = new VibrationSystem.Data();
        this.vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    }

    public VibrationSystem.User createVibrationUser() {
        return new VibrationUser(this.m_58899_());
    }

    public void tickFlower() {
        super.tickFlower();
        VibrationSystem.Ticker.m_280259_((Level)this.f_58857_, (VibrationSystem.Data)this.m_280002_(), (VibrationSystem.User)this.m_280445_());
        this.hasOvergrownSoil = this.overgrowth;
        if (this.activeTicks > 0 && !this.overgrowthBoost) {
            long ticksExisted = this.f_58857_.m_46467_();
            if (this.hasOvergrownSoil && ticksExisted % 3L != 0L || ticksExisted % 4L == 0L) {
                this.addMana(1);
                this.sync();
            }
            --this.activeTicks;
        }
    }

    public boolean isOvergrowthAffected() {
        return false;
    }

    public int getMaxMana() {
        return this.hasOvergrownSoil ? 2000 : 1000;
    }

    public int getColor() {
        return 1930633;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.f_58858_, 8.0);
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    public void setLastVibrationFrequency(int p_222801_) {
        this.lastVibrationFrequency = p_222801_;
    }

    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    protected class VibrationUser
    implements VibrationSystem.User {
        public static final int LISTENER_RANGE = 8;
        protected final BlockPos blockPos;
        private final PositionSource positionSource;

        public VibrationUser(BlockPos p_283482_) {
            this.blockPos = p_283482_;
            this.positionSource = new BlockPositionSource(p_283482_);
        }

        public int m_280351_() {
            return 8;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, @Nullable GameEvent.Context context) {
            if (context != null && context.f_223711_() instanceof ManaBurst) {
                return false;
            }
            if (event == GameEvent.f_157778_ && (context == null || context.f_223711_() == null)) {
                return false;
            }
            return !Vibrantia.this.m_58901_() && (!pos.equals((Object)Vibrantia.this.m_58899_()) || event != GameEvent.f_157794_ && event != GameEvent.f_157797_) && SculkSensorBlock.m_154487_((BlockState)Vibrantia.this.m_58900_()) == SculkSensorPhase.INACTIVE;
        }

        public void m_280271_(ServerLevel p_282851_, BlockPos p_281608_, GameEvent event, @Nullable Entity ent, @Nullable Entity ent2, float p_283130_) {
            if (ent instanceof ManaBurst) {
                return;
            }
            if (event == GameEvent.f_157778_ && ent == null && ent2 == null) {
                return;
            }
            BlockState blockstate = Vibrantia.this.m_58900_();
            if (SculkSensorBlock.m_154489_((BlockState)blockstate)) {
                Vibrantia.this.lastVibrationFrequency = VibrationSystem.m_280122_((GameEvent)event);
                Vibrantia.this.activeTicks = 40;
                VibrantiaBlock.activate(ent, Vibrantia.this.f_58857_, Vibrantia.this.f_58858_, blockstate);
            }
        }

        public void m_280022_() {
            Vibrantia.this.m_6596_();
        }

        public boolean m_280215_() {
            return true;
        }
    }
}

