/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.crafting.RecipeGaiaPlate;
import org.zeith.botanicadds.init.BlocksBA;
import org.zeith.botanicadds.init.RecipeTypesBA;
import org.zeith.botanicadds.init.TilesBA;
import org.zeith.botanicadds.util.SparkUtil;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyInt;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileGaiaPlate
extends TileSyncableTickable
implements SparkAttachable,
ManaReceiver {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}}, new Object[]{Character.valueOf('P'), BlocksBA.GAIA_PLATE, Character.valueOf('R'), PatchouliAPI.get().strictBlockMatcher((Block)BlocksBA.DREAMROCK), Character.valueOf('0'), PatchouliAPI.get().strictBlockMatcher((Block)BlocksBA.DREAMROCK), Character.valueOf('L'), PatchouliAPI.get().tagMatcher(BlocksBA.ELVEN_LAPIS_BLOCK.blockTag)}));
    @NBTSerializable
    private int mana;
    public final PropertyInt currentMana = new PropertyInt(DirectStorage.create(v -> {
        this.mana = v;
    }, () -> this.mana));
    private final LazyOptional<SparkAttachable> sparkLazy = LazyOptional.of(() -> this);
    private final LazyOptional<ManaReceiver> receiverLazy = LazyOptional.of(() -> this);

    public TileGaiaPlate(BlockPos pos, BlockState state) {
        super(TilesBA.GAIA_PLATE, pos, state);
        this.dispatcher.registerProperty("mana", (IProperty)this.currentMana);
    }

    public void update() {
        super.update();
        if (this.isOnServer()) {
            boolean removeMana = true;
            if (this.hasValidPlatform()) {
                List<ItemStack> items = this.getItems();
                SimpleContainer inv = this.getInventory();
                RecipeGaiaPlate recipe = this.getCurrentRecipe(inv);
                if (recipe != null) {
                    removeMana = false;
                    ManaSpark spark = this.getAttachedSpark();
                    SparkUtil.startRequestingMana((BlockEntity)this, spark);
                    if (this.mana > 0) {
                        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
                        int proportion = Float.floatToIntBits(this.getCompletion());
                        XplatAbstractions.INSTANCE.sendToNear(this.f_58857_, this.f_58858_, (BotaniaPacket)new BotaniaEffectPacket(EffectType.TERRA_PLATE, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), new int[]{proportion}));
                    }
                    if (this.mana >= recipe.getMana()) {
                        ItemStack result = recipe.m_5874_((Container)inv, this.f_58857_.m_9598_());
                        for (ItemStack item : items) {
                            item.m_41764_(0);
                        }
                        ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.2, (double)this.f_58858_.m_123343_() + 0.5, result);
                        item.m_20256_(Vec3.f_82478_);
                        this.f_58857_.m_7967_((Entity)item);
                        this.f_58857_.m_6263_(null, item.m_20185_(), item.m_20186_(), item.m_20189_(), BotaniaSounds.terrasteelCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.mana = 0;
                        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
                    }
                }
            }
            if (removeMana) {
                this.receiveMana(-1000);
            }
        }
    }

    private List<ItemStack> getItems() {
        List itemEntities = this.f_58857_.m_6443_(ItemEntity.class, new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1)), EntitySelector.f_20402_);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemEntity entity : itemEntities) {
            if (entity.m_32055_().m_41619_()) continue;
            stacks.add(entity.m_32055_());
        }
        return stacks;
    }

    private SimpleContainer getInventory() {
        List<ItemStack> items = this.getItems();
        return new SimpleContainer(TileGaiaPlate.flattenStacks(items));
    }

    private static ItemStack[] flattenStacks(List<ItemStack> items) {
        int i = 0;
        for (ItemStack item : items) {
            i += item.m_41613_();
        }
        if (i > 64) {
            return new ItemStack[0];
        }
        ItemStack[] stacks = new ItemStack[i];
        int j = 0;
        for (ItemStack item : items) {
            if (item.m_41613_() > 1) {
                ItemStack temp = item.m_41777_();
                temp.m_41764_(1);
                for (int count = 0; count < item.m_41613_(); ++count) {
                    stacks[j] = temp.m_41777_();
                    ++j;
                }
                continue;
            }
            stacks[j] = item;
            ++j;
        }
        return stacks;
    }

    @Nullable
    private RecipeGaiaPlate getCurrentRecipe(SimpleContainer items) {
        return items.m_7983_() ? null : (RecipeGaiaPlate)this.f_58857_.m_7465_().m_44015_((RecipeType)RecipeTypesBA.GAIA_PLATE, (Container)items, this.f_58857_).orElse(null);
    }

    private boolean isActive() {
        return this.getCurrentRecipe(this.getInventory()) != null;
    }

    private boolean hasValidPlatform() {
        return MULTIBLOCK.get().validate(this.f_58857_, this.m_58899_().m_7495_()) != null;
    }

    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        RecipeGaiaPlate recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null || this.getCurrentMana() >= recipe.getMana();
    }

    public void receiveMana(int mana) {
        this.mana = Math.max(0, this.mana + mana);
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
    }

    public boolean canReceiveManaFromBursts() {
        return this.isActive();
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            return (ManaSpark)Cast.cast(sparks.get(0));
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return !this.isActive();
    }

    public int getAvailableSpaceForMana() {
        RecipeGaiaPlate recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null ? 0 : Math.max(0, recipe.getMana() - this.getCurrentMana());
    }

    public float getCompletion() {
        RecipeGaiaPlate recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null ? 0.0f : (float)this.getCurrentMana() / (float)recipe.getMana();
    }

    public int getComparatorLevel() {
        int val = (int)((double)this.getCompletion() * 15.0);
        if (this.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeCapabilities.SPARK_ATTACHABLE) {
            return BotaniaForgeCapabilities.SPARK_ATTACHABLE.orEmpty(cap, this.sparkLazy);
        }
        if (cap == BotaniaForgeCapabilities.MANA_RECEIVER) {
            return BotaniaForgeCapabilities.MANA_RECEIVER.orEmpty(cap, this.receiverLazy);
        }
        return super.getCapability(cap, side);
    }
}

