/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.compat.jei.cats;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.zeith.botanicadds.BotanicAdditions;
import org.zeith.botanicadds.crafting.RecipeGaiaPlate;
import org.zeith.botanicadds.init.BlocksBA;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerrestrialAgglomerationDrawable;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class GaiaPlateRecipeCategory
implements IRecipeCategory<RecipeGaiaPlate> {
    public static final RecipeType<RecipeGaiaPlate> TYPE = new RecipeType(BotanicAdditions.id("gaia_plate"), RecipeGaiaPlate.class);
    private final Component localizedName;
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable terraPlate;

    public GaiaPlateRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocationHelper.prefix((String)"textures/gui/terrasteel_jei_overlay.png");
        this.background = guiHelper.createBlankDrawable(114, 131);
        this.overlay = guiHelper.createDrawable(location, 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlocksBA.GAIA_PLATE));
        this.localizedName = BlocksBA.GAIA_PLATE.m_49954_();
        IDrawable livingrock = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlocksBA.DREAMROCK));
        this.terraPlate = new TerrestrialAgglomerationDrawable(livingrock, livingrock, guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlocksBA.ELVEN_LAPIS_BLOCK)));
    }

    @NotNull
    public RecipeType<RecipeGaiaPlate> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull RecipeGaiaPlate recipe, @NotNull IRecipeSlotsView view, @NotNull GuiGraphics ms, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 25, 14);
        HUDHandler.renderManaBar((GuiGraphics)ms, (int)6, (int)126, (int)255, (float)0.75f, (int)recipe.getMana(), (int)1000000);
        this.terraPlate.draw(ms, 35, 92);
        RenderSystem.disableBlend();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull RecipeGaiaPlate recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 37).addItemStack(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        double angleBetweenEach = 360.0 / (double)recipe.m_7527_().size();
        Vec2 point = new Vec2(48.0f, 5.0f);
        Vec2 center = new Vec2(48.0f, 37.0f);
        for (Ingredient ingr : recipe.m_7527_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)point.f_82470_, (int)point.f_82471_).addIngredients(ingr);
            point = PetalApothecaryRecipeCategory.rotatePointAbout((Vec2)point, (Vec2)center, (double)angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 48, 92).addItemStack(new ItemStack((ItemLike)BlocksBA.GAIA_PLATE));
    }
}

