/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.compat.jei;

import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.zeith.botanicadds.BotanicAdditions;
import org.zeith.botanicadds.compat.jei.cats.GaiaPlateRecipeCategory;
import org.zeith.botanicadds.init.BlocksBA;
import org.zeith.botanicadds.init.RecipeTypesBA;
import org.zeith.hammerlib.compat.jei.JeiHammerLib;
import vazkii.botania.client.integration.jei.BreweryRecipeCategory;
import vazkii.botania.client.integration.jei.RunicAltarRecipeCategory;

@JeiPlugin
public class JeiBA
implements IModPlugin {
    public static final ResourceLocation ID = BotanicAdditions.id("jei");
    private static final Comparator<Recipe<?>> BY_ID = Comparator.comparing(Recipe::m_6423_);

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new GaiaPlateRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(GaiaPlateRecipeCategory.TYPE, JeiBA.sortRecipes(RecipeTypesBA.GAIA_PLATE, BY_ID));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlocksBA.ELVEN_ALTAR), new RecipeType[]{RunicAltarRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlocksBA.ELVEN_BREWERY), new RecipeType[]{BreweryRecipeCategory.TYPE});
    }

    private static <T extends Recipe<C>, C extends Container> List<T> sortRecipes(net.minecraft.world.item.crafting.RecipeType<T> type, Comparator<? super T> comparator) {
        return JeiHammerLib.getRecipes(type).sorted(comparator).toList();
    }
}

