/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.blocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.blocks.SimpleBlockBA;
import org.zeith.botanicadds.init.ItemsBA;
import org.zeith.botanicadds.tiles.TileManaTesseract;
import org.zeith.botanicadds.world.WorldTesseractData;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.core.adapter.BlockHarvestAdapter;
import org.zeith.hammerlib.util.java.Cast;

public class BlockManaTesseract
extends SimpleBlockBA
implements EntityBlock {
    public static final EnumProperty<WorldTesseractData.TesseractMode> MODE = EnumProperty.m_61587_((String)"mode", WorldTesseractData.TesseractMode.class);

    public BlockManaTesseract() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.5f).m_60999_());
        BlockHarvestAdapter.bindTool((BlockHarvestAdapter.MineableType)BlockHarvestAdapter.MineableType.PICKAXE, (Tier)Tiers.IRON, (Block[])new Block[]{this});
    }

    public static Optional<String> getChannel(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("Channel", 8) ? Optional.of(stack.m_41783_().m_128461_("Channel")) : Optional.empty();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODE});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity ent, ItemStack stack) {
        BlockManaTesseract.getChannel(stack).ifPresent(ch -> Cast.optionally((Object)level.m_7702_(pos), TileManaTesseract.class).ifPresent(tess -> {
            tess.isPrivate = ItemsBA.TESSERACT_ATTUNER.isPrivate(stack);
            tess.channelReadable = ch;
            if (ent instanceof Player) {
                Player pl = (Player)ent;
                tess.owner = pl.m_36316_();
                tess.channelOwnerName = tess.owner.getName();
            }
        }));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        if (BlockManaTesseract.getChannel(ctx.m_43722_()).isEmpty()) {
            Player pl = ctx.m_43723_();
            if (pl != null && !pl.m_9236_().f_46443_) {
                pl.m_5661_((Component)Component.m_237115_((String)"info.botanicadds.mana_tesseract.no_channel").m_130948_(Style.f_131099_.m_178520_(0xA30000)), true);
            }
            return null;
        }
        return super.m_5573_(ctx);
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack item = new ItemStack((ItemLike)this);
        LootParams ctx = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81421_);
        ItemStack savedItem = Cast.optionally((Object)ctx.m_287267_(LootContextParams.f_81462_), TileManaTesseract.class).map(t -> t.storeData(item)).orElse(item);
        return List.of(savedItem);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack item = new ItemStack((ItemLike)this);
        return Cast.optionally((Object)level.m_7702_(pos), TileManaTesseract.class).map(t -> t.storeData(item)).orElse(item);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileManaTesseract(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return BlockAPI.ticker();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        BlockManaTesseract.getChannel(stack).ifPresent(channel -> tooltip.add((Component)Component.m_237110_((String)"info.botanicadds.mana_tesseract.channel", (Object[])new Object[]{Component.m_237113_((String)channel).m_130948_(Style.f_131099_.m_178520_(42347))}).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x444444))));
        int modeColor = 0x22AA22;
        String mode = "public";
        if (ItemsBA.TESSERACT_ATTUNER.isPrivate(stack)) {
            modeColor = 0xAA2222;
            mode = "private";
        }
        tooltip.add((Component)Component.m_237110_((String)"info.botanicadds.tesseract_attuner.mode", (Object[])new Object[]{Component.m_237115_((String)("info.botanicadds.tesseract_attuner.mode." + mode)).m_130948_(Style.f_131099_.m_178520_(modeColor))}).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x444444)));
    }
}

