/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.client.util.Animation;
import com.bonker.stardewfishing.client.util.RenderUtil;
import com.bonker.stardewfishing.client.util.Shake;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.bonker.stardewfishing.proxy.ItemUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RodTooltipHandler {
    private static final ResourceLocation TEXTURE = StardewFishing.resource("textures/gui/tooltip.png");
    private static final Multimap<Slot, Tooltip> MAP = HashMultimap.create();
    private static int soundTimer = 0;

    public static void tick(Slot hovered, ItemStack carried) {
        ItemStack stack;
        if (soundTimer > 0) {
            --soundTimer;
        }
        if (SFConfig.isInventoryEquippingEnabled() && hovered != null && !MAP.containsKey((Object)hovered) && ItemUtils.isFishingRod(stack = hovered.m_7993_())) {
            MAP.put((Object)hovered, (Object)new Tooltip(hovered));
        }
        MAP.entries().removeIf(entry -> ((Tooltip)entry.getValue()).tick(hovered, carried));
    }

    public static void clear() {
        MAP.clear();
    }

    public static void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        MAP.values().forEach(tooltip -> tooltip.render(guiGraphics, partialTick, mouseX, mouseY));
    }

    public static void addShake(Slot slot, boolean equip) {
        for (Map.Entry entry : MAP.entries()) {
            if (((Slot)entry.getKey()).getSlotIndex() != slot.getSlotIndex()) continue;
            ((Tooltip)entry.getValue()).setShake(equip ? 6 : 2);
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)(equip ? (SoundEvent)SFSoundEvents.EQUIP.get() : (SoundEvent)SFSoundEvents.UNEQUIP.get()), (float)1.0f));
    }

    public static class Tooltip {
        private final Animation slotAnim = new Animation(0.0f);
        private final Animation mouseAnim = new Animation(0.0f);
        private final Shake shake = new Shake(2.0f, 1);
        private final Slot slot;
        private ItemStack stack;
        private int shakeDuration = 1;
        private int shakeTicks = 0;
        private boolean hoveredLastTick = false;

        public Tooltip(Slot slot) {
            this.slot = slot;
            this.stack = slot.m_7993_().m_41777_();
        }

        public boolean tick(Slot hovered, ItemStack carried) {
            boolean showMouse;
            boolean isRod = true;
            if (!this.slot.m_7993_().equals(this.stack)) {
                if (ItemUtils.isFishingRod(this.slot.m_7993_())) {
                    this.stack = this.slot.m_7993_().m_41777_();
                } else {
                    isRod = false;
                }
            }
            boolean bl = showMouse = this.shakeTicks == 0;
            if (isRod && hovered == this.slot) {
                this.slotAnim.addValue(0.33333334f, 0.0f, 1.0f);
                boolean bl2 = showMouse = showMouse && ItemUtils.isBobber(carried);
                if (!this.hoveredLastTick) {
                    if (soundTimer == 0) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SFSoundEvents.DWOP.get()), (float)1.0f));
                        soundTimer = 4;
                    }
                    this.hoveredLastTick = true;
                }
            } else {
                this.slotAnim.addValue(-0.33333334f, 0.0f, 1.0f);
                showMouse = false;
                if (this.slotAnim.getInterpolated(0.0f) == 0.0f) {
                    return true;
                }
                if (this.hoveredLastTick) {
                    if (soundTimer == 0) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SFSoundEvents.DWOP_REVERSE.get()), (float)1.0f));
                    }
                    this.hoveredLastTick = false;
                }
            }
            this.shake.setValues(2.5f * (float)this.shakeTicks / (float)this.shakeDuration, 1);
            this.shakeTicks = Math.max(0, this.shakeTicks - 1);
            this.shake.tick();
            if (showMouse) {
                this.mouseAnim.addValue(0.33333334f, 0.0f, 1.0f);
            } else {
                this.mouseAnim.addValue(-0.33333334f, 0.0f, 1.0f);
            }
            return false;
        }

        public void setShake(int duration) {
            this.shakeDuration = duration;
            this.shakeTicks = duration;
        }

        public void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 370.0f);
            RenderUtil.drawWithShake(guiGraphics.m_280168_(), this.shake, partialTick, true, () -> RenderUtil.drawWithBlend(() -> this.renderSlot(guiGraphics, partialTick)));
            RenderUtil.drawWithBlend(() -> this.renderMouse(guiGraphics, partialTick, mouseX, mouseY));
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderSlot(GuiGraphics guiGraphics, float partialTick) {
            float anim = this.slotAnim.getInterpolated(partialTick);
            float x = 1.0f / anim * (float)(this.slot.f_40220_ + 8);
            float y = 1.0f / anim * (float)(this.slot.f_40221_ + 8);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(anim, anim, 1.0f);
            RenderUtil.blitF(guiGraphics, TEXTURE, x - 35.0f, y - 12.0f, 0, 0, 29, 27);
            RenderUtil.renderItemF(guiGraphics, ItemUtils.getBobber(this.stack), x - 30.0f, y - 8.0f);
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderMouse(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            float anim = this.mouseAnim.getInterpolated(partialTick);
            float x = 1.0f / anim * (float)mouseX;
            float y = 1.0f / anim * (float)mouseY;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(anim, anim, 1.0f);
            RenderUtil.blitF(guiGraphics, TEXTURE, x + 3.0f, y + 3.0f, 33, 0, 11, 19);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

