/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.random_block_ticking;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.lychee.Lychee;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.type.BlockKeyRecipeType;
import snownee.lychee.mixin.ChunkMapAccess;
import snownee.lychee.random_block_ticking.RandomBlockTickingRecipe;
import snownee.lychee.random_block_ticking.RandomlyTickable;
import snownee.lychee.util.BlockStateSet;
import snownee.lychee.util.CommonProxy;

public class RandomBlockTickingRecipeType
extends BlockKeyRecipeType<LycheeContext, RandomBlockTickingRecipe> {
    public RandomBlockTickingRecipeType(String name, Class<RandomBlockTickingRecipe> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
    }

    @Override
    public void buildCache() {
        boolean prevEmpty = this.isEmpty();
        super.buildCache();
        if (prevEmpty && this.recipes.isEmpty()) {
            return;
        }
        Predicate<BlockState> predicate = this.anyBlockRecipes.isEmpty() ? BlockStateSet.NONE : BlockStateSet.ANY;
        for (Block block : BuiltInRegistries.f_256975_) {
            ((RandomlyTickable)block).lychee$setTickable(predicate);
        }
        if (this.anyBlockRecipes.isEmpty()) {
            for (Map.Entry entry : this.recipesByBlock.entrySet()) {
                Block block = (Block)entry.getKey();
                Stream<BlockPredicate> stream = ((List)entry.getValue()).stream().map(RandomBlockTickingRecipe::getBlock);
                ((RandomlyTickable)block).lychee$setTickable(BlockStateSet.of(block, stream));
            }
        }
        Blocks.m_50758_();
        if (CommonProxy.hasKiwi) {
            MinecraftServer server = Platform.getServer();
            if (server == null) {
                return;
            }
            for (ServerLevel level : server.m_129785_()) {
                for (ChunkHolder chunkHolder : ((ChunkMapAccess)level.m_7726_().f_8325_).callGetChunks()) {
                    LevelChunk chunk = chunkHolder.m_140085_();
                    if (chunk == null) continue;
                    for (LevelChunkSection section : chunk.m_7103_()) {
                        section.m_63018_();
                    }
                }
            }
        } else {
            String s = "Random block ticking recipes require Kiwi to be installed!";
            Lychee.LOGGER.warn(s);
            if (CommonProxy.isPhysicalClient()) {
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91074_ != null) {
                    minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)s));
                }
            }
        }
    }
}

