/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin;

import java.util.function.Predicate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.lychee.random_block_ticking.RandomlyTickable;
import snownee.lychee.util.BlockStateSet;

@Mixin(value={Block.class})
public class BlockMixin
implements RandomlyTickable {
    @Unique
    private Predicate<BlockState> lychee$randomlyTickable = BlockStateSet.NONE;

    @Inject(at={@At(value="HEAD")}, method={"isRandomlyTicking"}, cancellable=true)
    private void isRandomlyTicking(BlockState blockState, CallbackInfoReturnable<Boolean> ci) {
        if (this.lychee$isTickable(blockState)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Override
    public void lychee$setTickable(Predicate<BlockState> randomlyTickable) {
        this.lychee$randomlyTickable = randomlyTickable;
    }

    @Override
    public boolean lychee$isTickable(BlockState blockState) {
        return this.lychee$randomlyTickable.test(blockState);
    }
}

