/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post.input;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.Reference;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class DamageItem
extends PostAction {
    public final int damage;
    public final Reference target;

    public DamageItem(int damage, Reference target) {
        this.damage = damage;
        this.target = target;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.DAMAGE_ITEM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        Entity thisEntity = (Entity)ctx.getParam(LootContextParams.f_81455_);
        LivingEntity entity = thisEntity instanceof LivingEntity ? (LivingEntity)thisEntity : null;
        for (Integer index : indexes) {
            ctx.itemHolders.ignoreConsumptionFlags.set(index);
            ItemStack itemStack = ctx.itemHolders.split(index, 1).get();
            if (entity == null) {
                if (!itemStack.m_220157_(this.damage, ctx.getRandom(), null)) continue;
                itemStack.m_41774_(1);
                itemStack.m_41721_(0);
                continue;
            }
            if (entity.m_21205_() == itemStack) {
                itemStack.m_41622_(this.damage, entity, $ -> $.m_21166_(EquipmentSlot.MAINHAND));
                continue;
            }
            if (entity.m_21206_() == itemStack) {
                itemStack.m_41622_(this.damage, entity, $ -> $.m_21166_(EquipmentSlot.OFFHAND));
                continue;
            }
            itemStack.m_41622_(this.damage, entity, $ -> {});
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkArgument((!recipe.getItemIndexes(this.target).isEmpty() ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    public static class Type
    extends PostActionType<DamageItem> {
        @Override
        public DamageItem fromJson(JsonObject o) {
            return new DamageItem(GsonHelper.m_13824_((JsonObject)o, (String)"damage", (int)1), Reference.fromJson(o, "target"));
        }

        @Override
        public void toJson(DamageItem action, JsonObject o) {
            if (action.damage != 1) {
                o.addProperty("damage", (Number)1);
            }
            Reference.toJson(action.target, o, "target");
        }

        @Override
        public DamageItem fromNetwork(FriendlyByteBuf buf) {
            return new DamageItem(buf.m_130242_(), Reference.fromNetwork(buf));
        }

        @Override
        public void toNetwork(DamageItem action, FriendlyByteBuf buf) {
            buf.m_130130_(action.damage);
            Reference.toNetwork(action.target, buf);
        }
    }
}

