/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.Lychee;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.DoubleBoundsHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class Hurt
extends PostAction {
    public final MinMaxBounds.Doubles damage;
    public final ResourceLocation source;

    public Hurt(MinMaxBounds.Doubles damage, ResourceLocation source) {
        this.damage = damage;
        this.source = source;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.HURT;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Entity entity = (Entity)ctx.getParam(LootContextParams.f_81455_);
        entity.f_19802_ = 0;
        try {
            entity.m_6469_(entity.m_269291_().m_269079_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)this.source)), DoubleBoundsHelper.random(this.damage, ctx.getRandom()) * (float)times);
        }
        catch (Exception e) {
            Lychee.LOGGER.error("Failed to hurt entity", (Throwable)e);
        }
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237110_((String)CommonProxy.makeDescriptionId("postAction", this.getType().getRegistryName()), (Object[])new Object[]{BoundsHelper.getDescription(this.damage)});
    }

    public static class Type
    extends PostActionType<Hurt> {
        @Override
        public Hurt fromJson(JsonObject o) {
            ResourceLocation source = new ResourceLocation(GsonHelper.m_13851_((JsonObject)o, (String)"source", (String)"generic"));
            return new Hurt(MinMaxBounds.Doubles.m_154791_((JsonElement)o.get("damage")), source);
        }

        @Override
        public void toJson(Hurt action, JsonObject o) {
            o.add("damage", action.damage.m_55328_());
            o.addProperty("source", action.source.toString());
        }

        @Override
        public Hurt fromNetwork(FriendlyByteBuf buf) {
            return new Hurt(DoubleBoundsHelper.fromNetwork(buf), buf.m_130281_());
        }

        @Override
        public void toNetwork(Hurt action, FriendlyByteBuf buf) {
            DoubleBoundsHelper.toNetwork(action.damage, buf);
            buf.m_130085_(action.source);
        }
    }
}

