/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ParseResults;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public record Execute(String command, MinMaxBounds.Ints bounds) implements ContextualCondition
{
    public static final MinMaxBounds.Ints DEFAULT_RANGE = MinMaxBounds.Ints.m_55386_((int)1);
    public static final Execute DUMMY = new Execute("", DEFAULT_RANGE);

    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.EXECUTE;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        ParseResults results;
        if (this.command.isEmpty() || ctx.getLevel().f_46443_) {
            return 0;
        }
        Vec3 pos = (Vec3)ctx.getParam(LootContextParams.f_81460_);
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.f_81455_);
        Vec2 rotation = Vec2.f_82462_;
        Component displayName = snownee.lychee.core.post.Execute.DEFAULT_NAME;
        String name = "lychee";
        if (entity != null) {
            rotation = entity.m_20155_();
            displayName = entity.m_5446_();
            name = entity.m_7755_().getString();
        }
        CommandSourceStack sourceStack = new CommandSourceStack(CommandSource.f_80164_, pos, rotation, ctx.getServerLevel(), 2, name, displayName, ctx.getLevel().m_7654_(), entity);
        Commands cmds = ctx.getLevel().m_7654_().m_129892_();
        int i = cmds.m_242674_(results = cmds.m_82094_().parse(this.command, (Object)sourceStack), this.command);
        return this.bounds.m_55390_(i) ? times : 0;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        return Component.m_237115_((String)this.makeDescriptionId(false));
    }

    public static class Type
    extends ContextualConditionType<Execute> {
        @Override
        public Execute fromJson(JsonObject o) {
            MinMaxBounds.Ints bounds = DEFAULT_RANGE;
            if (o.has("value")) {
                bounds = MinMaxBounds.Ints.m_55373_((JsonElement)o.get("value"));
            }
            return new Execute(GsonHelper.m_13906_((JsonObject)o, (String)"command"), bounds);
        }

        @Override
        public void toJson(Execute condition, JsonObject o) {
            o.addProperty("command", condition.command());
            if (condition.bounds() != DEFAULT_RANGE) {
                o.add("value", condition.bounds().m_55328_());
            }
        }

        @Override
        public Execute fromNetwork(FriendlyByteBuf buf) {
            return DUMMY;
        }

        @Override
        public void toNetwork(Execute condition, FriendlyByteBuf buf) {
        }
    }
}

