/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class MagiscytheSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;

    public MagiscytheSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            if (attacker.m_21023_((MobEffect)EffectRegistry.MAGISTORM.get())) {
                world.m_5594_(null, attacker.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), attacker.m_5720_(), 0.1f, 1.9f);
                float repairChance = Config.getFloat("magistormRepairChance", "UniqueEffects", ConfigDefaultValues.magistormRepairChance);
                Random random = new Random();
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack item;
                    if (slot.m_20743_() != EquipmentSlot.Type.ARMOR && slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND || (item = attacker.m_6844_(slot)).m_41619_() || !(random.nextFloat() < repairChance) || item.m_41773_() <= 0) continue;
                    item.m_41721_((int)((double)item.m_41773_() - HelperMethods.getAttackDamage(stack)));
                    break;
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int skillCooldown = (int)Config.getFloat("magistormCooldown", "UniqueEffects", ConfigDefaultValues.magistormCooldown);
        int baseEffectDuration = (int)Config.getFloat("magistormDuration", "UniqueEffects", ConfigDefaultValues.magistormDuration);
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_22.get(), user.m_5720_(), 0.2f, 1.1f);
        user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.MAGISTORM.get(), baseEffectDuration, 1));
        user.m_36335_().m_41524_((Item)this, skillCooldown);
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(0.5f, entity, "arcane") > 0.0f) {
            scalesWithSpellPower = true;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123809_, ParticleTypes.f_123809_, ParticleTypes.f_123783_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip10").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip11").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magiscythesworditem.tooltip12").m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleArcane"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

