/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Elephant
extends NaturalistAnimal
implements NeutralMob,
NaturalistGeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.elephant.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.elephant.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.elephant.run");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> DRINKING = SynchedEntityData.m_135353_(Elephant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Elephant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public Elephant(EntityType<? extends NaturalistAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new MMPathNavigatorGround((Mob)this, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 1.2).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, 15.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        AgeableMob.AgeableMobGroupData ageableMobGroupData;
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(true);
        }
        if ((ageableMobGroupData = (AgeableMob.AgeableMobGroupData)spawnData).m_146777_() > 1) {
            this.m_146762_(-24000);
        }
        ageableMobGroupData.m_146778_();
        RandomSource random = level.m_213780_();
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", random.m_216328_(0.0, 0.11485000000000001), AttributeModifier.Operation.MULTIPLY_BASE));
        return spawnData;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NaturalistEntityTypes.ELEPHANT.get().m_20615_((Level)serverLevel);
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.2);
        } else {
            this.m_6858_(false);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Bee.class, 8.0f, 1.3, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new ElephantMeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(4, (Goal)new DistancedFollowParentGoal(this, 1.2, 24.0, 6.0, 12.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BabyHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Elephant)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public int m_8085_() {
        return 35;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return NaturalistSoundEvents.ELEPHANT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return NaturalistSoundEvents.ELEPHANT_AMBIENT.get();
    }

    public boolean m_7327_(Entity target) {
        boolean shouldHurt = target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (shouldHurt && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            Vec3 knockbackDirection = new Vec3((double)this.m_20183_().m_123341_() - target.m_20185_(), 0.0, (double)this.m_20183_().m_123343_() - target.m_20189_()).m_82541_();
            float shieldBlockModifier = livingEntity.m_21275_(target.m_269291_().m_269333_((LivingEntity)this)) ? 0.5f : 1.0f;
            livingEntity.m_147240_((double)shieldBlockModifier * 3.0, knockbackDirection.m_7096_(), knockbackDirection.m_7094_());
            double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, 0.5 * knockbackResistance, 0.0));
        }
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return shouldHurt;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(DRINKING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)pTime);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @NotNull
    private <E extends Elephant> PlayState predicate(AnimationState<E> event) {
        if (this.m_6162_() || this.m_5448_() != null) {
            event.setControllerSpeed(1.3f + event.getLimbSwingAmount());
        }
        if (event.isMoving()) {
            if (this.m_20142_()) {
                event.getController().setAnimation(RUN);
            } else {
                event.getController().setAnimation(WALK);
            }
        } else {
            event.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <E extends Elephant> PlayState swingPredicate(@NotNull AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.sf_nba.elephant.swing"));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "swingController", 0, this::swingPredicate)});
    }

    static class ElephantMeleeAttackGoal
    extends MeleeAttackGoal {
        public ElephantMeleeAttackGoal(PathfinderMob pathfinderMob, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
            super(pathfinderMob, speedMultiplier, followingTargetEvenIfNotSeen);
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return Mth.m_14207_((float)this.f_25540_.m_20205_());
        }
    }
}

