/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.config;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ClientConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue enableNumberShortening;
    private static final Map<String, ChatFormatting> NUMBER_FORMATTING_COLOURS;
    private static final ForgeConfigSpec.ConfigValue<String> numberColour;

    public static ChatFormatting getNumberColour() {
        return NUMBER_FORMATTING_COLOURS.get(((String)numberColour.get()).toLowerCase());
    }

    static {
        NUMBER_FORMATTING_COLOURS = new HashMap<String, ChatFormatting>();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        EnumSet.complementOf(EnumSet.of(ChatFormatting.STRIKETHROUGH, new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RESET, ChatFormatting.UNDERLINE, ChatFormatting.ITALIC, ChatFormatting.OBFUSCATED})).forEach(chatFormatting -> NUMBER_FORMATTING_COLOURS.put(chatFormatting.m_126666_(), (ChatFormatting)chatFormatting));
        builder.comment("Client configs");
        enableNumberShortening = builder.comment("Enable number shortening. E.g. 1000000 becomes 1M.").define("Enable number shortening", true);
        numberColour = builder.comment(new String[]{"The colour of the exact count tooltip shown on items.", "Available colours (case insensitive):", String.join((CharSequence)",\n", NUMBER_FORMATTING_COLOURS.keySet().stream().sorted().toList())}).define("Exact count number colour", (Object)ChatFormatting.DARK_AQUA.m_126666_(), value -> NUMBER_FORMATTING_COLOURS.containsKey(Objects.requireNonNullElse((String)value, "").toLowerCase()));
        SPEC = builder.build();
    }
}

