/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.chatimpressiveanimation.forge.mixin;

import com.wulian.chatimpressiveanimation.ChatImpressiveAnimationExpectPlatform;
import com.wulian.chatimpressiveanimation.config.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ChatComponent.class})
public class ChatHudMixin {
    @Shadow
    private int f_93763_;
    @Shadow
    @Final
    private List<GuiMessage.Line> f_93761_;
    @Unique
    private final ArrayList<Long> messageTimestamps = new ArrayList();
    @Unique
    private final int chatSendingAnimationFadeTime;
    @Unique
    private int chatDisplacementY;

    public ChatHudMixin() {
        this.chatSendingAnimationFadeTime = ConfigUtil.getConfig().chatSendingAnimationFadeTime;
        this.chatDisplacementY = 0;
    }

    @Shadow
    private int m_240691_() {
        return 0;
    }

    @Unique
    private void calculateYOffset() {
        try {
            int lineHeight = this.m_240691_();
            float fadeOffsetYScale = 0.8f;
            float maxDisplacement = (float)lineHeight * fadeOffsetYScale;
            long timestamp = this.messageTimestamps.get(0);
            long timeAlive = System.currentTimeMillis() - timestamp;
            this.chatDisplacementY = timeAlive < (long)this.chatSendingAnimationFadeTime && this.f_93763_ == 0 ? (int)(maxDisplacement - (float)timeAlive / (float)this.chatSendingAnimationFadeTime * maxDisplacement) : 0;
        }
        catch (Exception ignored) {
            this.chatDisplacementY = 0;
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(GuiGraphics context, int currentTick, int mouseX, int mouseY, CallbackInfo ci) {
        if (!ConfigUtil.getConfig().enableChatSendingAnimation) {
            return;
        }
        this.calculateYOffset();
        float raisedOffset = 0.0f;
        Object object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:hud");
        if (object instanceof Integer) {
            Integer distance = (Integer)object;
            raisedOffset -= (float)distance.intValue();
        } else {
            object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:distance");
            if (object instanceof Integer) {
                Integer distance = (Integer)object;
                raisedOffset -= (float)distance.intValue();
            }
        }
        context.m_280168_().m_252880_(0.0f, (float)this.chatDisplacementY + raisedOffset, 0.0f);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRenderEnd(GuiGraphics context, int currentTick, int mouseX, int mouseY, CallbackInfo ci) {
        float raisedOffset = 0.0f;
        Object object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:hud");
        if (object instanceof Integer) {
            Integer distance = (Integer)object;
            raisedOffset -= (float)distance.intValue();
        } else {
            object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:distance");
            if (object instanceof Integer) {
                Integer distance = (Integer)object;
                raisedOffset -= (float)distance.intValue();
            }
        }
        context.m_280168_().m_252880_(0.0f, -((float)this.chatDisplacementY + raisedOffset), 0.0f);
    }

    @Inject(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;Lnet/minecraft/client/gui/hud/MessageIndicator;)V"}, at={@At(value="TAIL")})
    private void addMessage(Component message, MessageSignature signatureData, GuiMessageTag indicator, CallbackInfo ci) {
        this.messageTimestamps.add(0, System.currentTimeMillis());
        while (this.messageTimestamps.size() > this.f_93761_.size()) {
            this.messageTimestamps.remove(this.messageTimestamps.size() - 1);
        }
    }
}

