/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mixin.effect;

import com.mojang.authlib.GameProfile;
import dev.arbor.extrasoundsnext.sounds.SoundManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends AbstractClientPlayer {
    @Unique
    private static Long extraSoundsNext$lastPlayedTimes = 0L;
    @Unique
    private static final long extraSoundsNext$cooldown = 1000L;

    public ClientPlayerEntityMixin(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    protected void m_142540_(@NotNull MobEffectInstance effect, @Nullable Entity source) {
        super.m_142540_(effect, source);
        long currentTime = System.currentTimeMillis();
        if (currentTime - extraSoundsNext$lastPlayedTimes > 1000L) {
            SoundManager.effectChanged(effect.m_19544_(), SoundManager.EffectType.ADD);
            extraSoundsNext$lastPlayedTimes = currentTime;
        }
    }

    @Inject(method={"removeEffectNoUpdate"}, at={@At(value="HEAD")})
    private void extrasounds$effectRemoved(MobEffect type, CallbackInfoReturnable<MobEffectInstance> cir) {
        long currentTime = System.currentTimeMillis();
        if (this.m_21023_(type) && currentTime - extraSoundsNext$lastPlayedTimes > 1000L) {
            SoundManager.effectChanged(type, SoundManager.EffectType.REMOVE);
            extraSoundsNext$lastPlayedTimes = currentTime;
        }
    }
}

