/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.annotation.forge;

import com.mojang.text2speech.Narrator;
import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.annotation.AddonFinder;
import dev.arbor.extrasoundsnext.annotation.SoundsGenerator;
import dev.arbor.extrasoundsnext.mapping.DefaultAutoGenerator;
import dev.arbor.extrasoundsnext.mapping.SoundGenerator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class AddonFinderImpl {
    public static List<Field> getAnnotatedFields() {
        Type annotationType = Type.getType(SoundsGenerator.class);
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<Field> annotatedFields = new LinkedHashSet<Field>();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (annotationType == null || !Objects.equals(a.annotationType(), annotationType)) continue;
                try {
                    Class<?> asmClass = AddonFinder.loadClass(a.clazz().getClassName());
                    for (Field field : asmClass.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(SoundsGenerator.class)) continue;
                        if (!field.canAccess(null)) {
                            field.setAccessible(true);
                        }
                        annotatedFields.add(field);
                    }
                }
                catch (ClassNotFoundException e) {
                    Narrator.LOGGER.error("Failed to load class: {}", (Object)a.clazz().getClassName(), (Object)e);
                    if (FMLLoader.isProduction()) continue;
                    throw new RuntimeException(e);
                }
            }
        }
        return new ArrayList<Field>(annotatedFields);
    }

    public static List<SoundGenerator> getSoundGenerators() {
        ArrayList<SoundGenerator> list = new ArrayList<SoundGenerator>();
        ArrayList namespaces = new ArrayList();
        HashMap soundGenerators = new HashMap();
        List<Field> fields = AddonFinder.getSoundsGenerators();
        if (fields.isEmpty()) {
            throw new RuntimeException("No sound generators found!");
        }
        fields.forEach(field -> {
            block3: {
                try {
                    if (field.getType().equals(SoundGenerator.class)) {
                        SoundGenerator soundGenerator = (SoundGenerator)field.get(null);
                        soundGenerators.put(soundGenerator.namespace, soundGenerator.itemSoundGenerator);
                        ExtraSoundsNext.LOGGER.info("Loaded sound generator: {}", (Object)soundGenerator.namespace);
                    }
                }
                catch (IllegalAccessException e) {
                    ExtraSoundsNext.LOGGER.error("Failed to load field: {}", (Object)field.getName(), (Object)e);
                    if (FMLLoader.isProduction()) break block3;
                    throw new RuntimeException(e);
                }
            }
        });
        ModList.get().getMods().forEach(iModInfo -> namespaces.add(iModInfo.getModId()));
        for (String namespace : namespaces) {
            list.add(SoundGenerator.of(namespace, soundGenerators.getOrDefault(namespace, DefaultAutoGenerator::autoGenerator)));
        }
        return list;
    }
}

