/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth;

import com.mrbysco.neoauth.util.MicrosoftUtils;
import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoAuthConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static boolean isDefaults() {
        return Objects.equals(NeoAuthConfig.CLIENT.authorizeUrl.get(), "https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize") && Objects.equals(NeoAuthConfig.CLIENT.tokenUrl.get(), "https://login.microsoftonline.com/consumers/oauth2/v2.0/token") && Objects.equals(NeoAuthConfig.CLIENT.xboxAuthUrl.get(), "https://user.auth.xboxlive.com/user/authenticate") && Objects.equals(NeoAuthConfig.CLIENT.xboxXstsUrl.get(), "https://xsts.auth.xboxlive.com/xsts/authorize") && Objects.equals(NeoAuthConfig.CLIENT.mcAuthUrl.get(), "https://api.minecraftservices.com/authentication/login_with_xbox") && Objects.equals(NeoAuthConfig.CLIENT.mcProfileUrl.get(), "https://api.minecraftservices.com/minecraft/profile");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.EnumValue<MicrosoftUtils.MicrosoftPrompt> prompt;
        public final ForgeConfigSpec.IntValue port;
        public final ForgeConfigSpec.ConfigValue<? extends String> clientId;
        public final ForgeConfigSpec.ConfigValue<? extends String> authorizeUrl;
        public final ForgeConfigSpec.ConfigValue<? extends String> tokenUrl;
        public final ForgeConfigSpec.ConfigValue<? extends String> xboxAuthUrl;
        public final ForgeConfigSpec.ConfigValue<? extends String> xboxXstsUrl;
        public final ForgeConfigSpec.ConfigValue<? extends String> mcAuthUrl;
        public final ForgeConfigSpec.ConfigValue<? extends String> mcProfileUrl;
        public final ForgeConfigSpec.IntValue xPos;
        public final ForgeConfigSpec.IntValue yPos;
        public final ForgeConfigSpec.BooleanValue draggable;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Auth settings").push("microsoft");
            this.prompt = builder.comment("Indicates the type of user interaction that is required").defineEnum("prompt", (Enum)MicrosoftUtils.MicrosoftPrompt.DEFAULT);
            this.port = builder.comment("The port from which to listen for OAuth2 callbacks").defineInRange("port", 25585, 0, 65535);
            this.clientId = builder.comment("OAuth2 client id").define("clientId", (Object)"e16699bb-2aa8-46da-b5e3-45cbcce29091");
            this.authorizeUrl = builder.comment("OAuth2 authorization url").define("authorizeUrl", (Object)"https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize");
            this.tokenUrl = builder.comment("OAuth2 access token url").define("tokenUrl", (Object)"https://login.microsoftonline.com/consumers/oauth2/v2.0/token");
            this.xboxAuthUrl = builder.comment("Xbox authentication url").define("xboxAuthUrl", (Object)"https://user.auth.xboxlive.com/user/authenticate");
            this.xboxXstsUrl = builder.comment("Xbox XSTS authorization url").define("xboxXstsUrl", (Object)"https://xsts.auth.xboxlive.com/xsts/authorize");
            this.mcAuthUrl = builder.comment("Minecraft authentication url").define("mcAuthUrl", (Object)"https://api.minecraftservices.com/authentication/login_with_xbox");
            this.mcProfileUrl = builder.comment("Minecraft profile url").define("mcProfileUrl", (Object)"https://api.minecraftservices.com/minecraft/profile");
            builder.pop();
            builder.comment("Button settings").push("buttons");
            this.xPos = builder.comment("X Position of the button on the multiplayer screen").defineInRange("xPos", 6, 0, Integer.MAX_VALUE);
            this.yPos = builder.comment("Y Position of the button on the multiplayer screen").defineInRange("yPos", 6, 0, Integer.MAX_VALUE);
            this.draggable = builder.comment("True if the button can be dragged to a new position").define("draggable", true);
            builder.pop();
        }
    }
}

