/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import me.Thelnfamous1.bettermobcombat.BetterMobCombat;
import me.Thelnfamous1.bettermobcombat.Constants;
import me.Thelnfamous1.bettermobcombat.api.MobAttackStrength;
import me.Thelnfamous1.bettermobcombat.api.MobAttackWindup;
import me.Thelnfamous1.bettermobcombat.client.BetterMobCombatEvents;
import me.Thelnfamous1.bettermobcombat.logic.MobAttackHelper;
import me.Thelnfamous1.bettermobcombat.logic.MobCombatHelper;
import me.Thelnfamous1.bettermobcombat.logic.MobTargetFinder;
import me.Thelnfamous1.bettermobcombat.platform.Services;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.EntityPlayer_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.utils.MathHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin_AttackLogic
extends LivingEntity
implements EntityPlayer_BetterCombat,
MobAttackStrength,
MobAttackWindup,
PlayerAttackProperties {
    @Unique
    private int bettermobcombat$comboCount = 0;
    @Unique
    private Multimap<Attribute, AttributeModifier> bettermobcombat$dualWieldingAttributeMap;
    @Unique
    private static final UUID bettermobcombat$DUAL_WIELDING_SPEED_MODIFIER_ID = UUID.fromString("6b364332-0dc4-11ed-861d-0242ac120002");
    @Unique
    private AttackHand bettermobcombat$lastAttack;
    @Unique
    private ItemStack bettermobcombat$lastItemInMainHand = ItemStack.f_41583_;
    @Unique
    private int bettermobcombat$attackCooldown;
    @Unique
    private ItemStack bettermobcombat$upswingStack;
    @Unique
    private ItemStack bettermobcombat$lastAttackedWithItemStack;
    @Unique
    private int bettermobcombat$upswingTicks = 0;
    @Unique
    private int bettermobcombat$lastAttacked = 1000;
    @Unique
    private float bettermobcombat$lastSwingDuration = 0.0f;
    @Unique
    private int bettermobcombat$comboReset = 0;
    @Unique
    private int bettermobcombat$upswingDelay;
    @Unique
    @Nullable
    private Runnable bettermobcombat$delayedUpswing;
    @Unique
    @Nullable
    private BiConsumer<Mob, Entity> bettermobcombat$customDamageApplicator;

    protected MobMixin_AttackLogic(EntityType<? extends LivingEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pre_tick(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            this.bettermobcombat$startUpswingIfDelayed();
            if (this.bettermobcombat$attackCooldown > 0) {
                --this.bettermobcombat$attackCooldown;
            }
            ++this.bettermobcombat$lastAttacked;
            this.bettermobcombat$cancelSwingIfNeeded();
            this.bettermobcombat$attackFromUpswingIfNeeded();
            this.bettermobcombat$resetComboIfNeeded();
        }
    }

    @Unique
    private void bettermobcombat$startUpswingIfDelayed() {
        if (this.bettermobcombat$upswingDelay > 0) {
            --this.bettermobcombat$upswingDelay;
            if (this.bettermobcombat$upswingDelay <= 0 && this.bettermobcombat$delayedUpswing != null) {
                if (!this.m_21224_()) {
                    this.bettermobcombat$delayedUpswing.run();
                }
                this.bettermobcombat$delayedUpswing = null;
            }
        }
    }

    @Unique
    private void bettermobcombat$cancelSwingIfNeeded() {
        if (this.bettermobcombat$upswingStack != null && !MobMixin_AttackLogic.bettermobcombat$areItemStackEqual(this.m_21205_(), this.bettermobcombat$upswingStack)) {
            this.bettermobcombat$cancelWeaponSwing();
        }
    }

    @Unique
    private static boolean bettermobcombat$areItemStackEqual(ItemStack left, ItemStack right) {
        if (left == null && right == null) {
            return true;
        }
        return left != null && right != null ? ItemStack.m_41728_((ItemStack)left, (ItemStack)right) : false;
    }

    @Unique
    public void bettermobcombat$cancelWeaponSwing() {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)this)) {
            return;
        }
        int downWind = (int)Math.round((double)MobAttackHelper.getAttackCooldownTicksCapped((Mob)this) * (1.0 - 0.5 * (double)BetterCombat.config.upswing_multiplier));
        Services.PLATFORM.stopMobAttackAnimation(this, downWind);
        this.bettermobcombat$upswingStack = null;
        this.bettermobcombat$setAttackCooldown(0);
    }

    @Unique
    private void bettermobcombat$attackFromUpswingIfNeeded() {
        if (this.bettermobcombat$upswingTicks > 0) {
            --this.bettermobcombat$upswingTicks;
            if (this.bettermobcombat$upswingTicks == 0) {
                this.bettermobcombat$performAttack();
                this.bettermobcombat$upswingStack = null;
            }
        }
    }

    @Unique
    private void bettermobcombat$performAttack() {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)this)) {
            return;
        }
        AttackHand hand = this.bettermobcombat$getCurrentHand();
        if (hand != null) {
            WeaponAttributes.Attack attack = hand.attack();
            double upswingRate = MobAttackHelper.getTotalUpswingRate(hand);
            if (!(this.bettercombat$getAttackStrengthScale(0.0f) < 1.0 - upswingRate)) {
                LivingEntity intendedTarget = MobTargetFinder.getAttackTarget((Mob)this);
                List<Entity> targets = MobTargetFinder.findAttackTargets((LivingEntity)((Mob)this), (Entity)intendedTarget, attack, hand.attributes().attackRange());
                if (intendedTarget == null && targets.isEmpty()) {
                    Constants.LOG.debug("Mob {} executed an attack with no AI attack target and no targets in range", (Object)this);
                }
                MobCombatHelper.processAttack(this.m_9236_(), (Mob)this, this.getComboCount(), targets, this.bettermobcombat$customDamageApplicator);
                this.bettercombat$resetAttackStrengthTicker();
                BetterMobCombatEvents.ATTACK_HIT.invoke(arg_0 -> this.lambda$bettermobcombat$performAttack$0(hand, targets, (Entity)intendedTarget, arg_0));
                this.setComboCount(this.getComboCount() + 1);
                if (!hand.isOffHand()) {
                    this.bettermobcombat$lastAttackedWithItemStack = hand.itemStack();
                }
            }
        }
    }

    @Unique
    @Nullable
    private AttackHand bettermobcombat$getCurrentHand() {
        return MobAttackHelper.getCurrentAttack((LivingEntity)((Mob)this), this.getComboCount());
    }

    @Unique
    private void bettermobcombat$resetComboIfNeeded() {
        if (this.bettermobcombat$lastAttacked > this.bettermobcombat$comboReset && this.getComboCount() > 0) {
            this.setComboCount(0);
        }
        if (!MobAttackHelper.shouldAttackWithOffHand((LivingEntity)((Mob)this), this.getComboCount()) && (this.m_21205_() == null || this.bettermobcombat$lastAttackedWithItemStack != null && !this.bettermobcombat$lastAttackedWithItemStack.m_41720_().equals(this.m_21205_().m_41720_()))) {
            this.setComboCount(0);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void post_tick(CallbackInfo ci) {
        if (this.m_9236_().f_46443_) {
            ((PlayerAttackAnimatable)this).updateAnimationsOnTick();
        }
        this.bettermobcombat$updateDualWieldingSpeedBoost();
        ++this.f_20922_;
        ItemStack itemstack = this.m_21205_();
        if (!ItemStack.m_41728_((ItemStack)this.bettermobcombat$lastItemInMainHand, (ItemStack)itemstack)) {
            if (!ItemStack.m_41656_((ItemStack)this.bettermobcombat$lastItemInMainHand, (ItemStack)itemstack)) {
                this.bettercombat$resetAttackStrengthTicker();
            }
            this.bettermobcombat$lastItemInMainHand = itemstack.m_41777_();
        }
    }

    @Unique
    private void bettermobcombat$updateDualWieldingSpeedBoost() {
        boolean currentState;
        Mob mob = (Mob)this;
        boolean newState = MobAttackHelper.isDualWielding((LivingEntity)mob);
        boolean bl = currentState = this.bettermobcombat$dualWieldingAttributeMap != null;
        if (newState != currentState) {
            if (newState) {
                this.bettermobcombat$dualWieldingAttributeMap = HashMultimap.create();
                double multiplier = BetterCombat.config.dual_wielding_attack_speed_multiplier - 1.0f;
                this.bettermobcombat$dualWieldingAttributeMap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(bettermobcombat$DUAL_WIELDING_SPEED_MODIFIER_ID, "Dual wielding attack speed boost", multiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                mob.m_21204_().m_22178_(this.bettermobcombat$dualWieldingAttributeMap);
            } else if (this.bettermobcombat$dualWieldingAttributeMap != null) {
                mob.m_21204_().m_22161_(this.bettermobcombat$dualWieldingAttributeMap);
                this.bettermobcombat$dualWieldingAttributeMap = null;
            }
        }
    }

    @Inject(method={"serverAiStep"}, at={@At(value="TAIL")})
    private void post_serverAiStep(CallbackInfo ci) {
        float swingProgress;
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)this)) {
            return;
        }
        double multiplier = Math.min(Math.max((double)BetterCombat.config.movement_speed_while_attacking, 0.0), 1.0);
        if (multiplier != 1.0 && (!this.m_20159_() || BetterCombat.config.movement_speed_effected_while_mounting) && (double)(swingProgress = this.bettermobcombat$getSwingProgress()) < 0.98) {
            if (BetterCombat.config.movement_speed_applied_smoothly) {
                double p2 = (double)swingProgress <= 0.5 ? MathHelper.easeOutCubic((double)(swingProgress * 2.0f)) : MathHelper.easeOutCubic((double)(1.0 - ((double)swingProgress - 0.5) * 2.0));
                multiplier = (float)(1.0 - (1.0 - multiplier) * p2);
            }
            this.f_20902_ *= (float)multiplier;
            this.f_20900_ *= (float)multiplier;
        }
    }

    @Inject(method={"getItemBySlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_getItemBySlot(EquipmentSlot slot, CallbackInfoReturnable<ItemStack> cir) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)this)) {
            return;
        }
        boolean mainHandHasTwoHanded = false;
        ItemStack mainHandStack = MobCombatHelper.getDirectMainhand((Mob)this);
        WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes((ItemStack)mainHandStack);
        if (mainHandAttributes != null && mainHandAttributes.isTwoHanded()) {
            mainHandHasTwoHanded = true;
        }
        boolean offHandHasTwoHanded = false;
        ItemStack offHandStack = MobCombatHelper.getDirectOffhand((Mob)this);
        WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes((ItemStack)offHandStack);
        if (offHandAttributes != null && offHandAttributes.isTwoHanded()) {
            offHandHasTwoHanded = true;
        }
        if (slot == EquipmentSlot.OFFHAND && (mainHandHasTwoHanded || offHandHasTwoHanded)) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
            cir.cancel();
        }
    }

    @ModifyArg(method={"doHurtTarget"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getDamageBonus(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/MobType;)F"), index=0)
    private ItemStack modify_getDamageBonus_doHurtTarget(ItemStack heldItem) {
        return this.bettermobcombat$getAlternateMainhandItem(heldItem);
    }

    @Unique
    protected ItemStack bettermobcombat$getAlternateMainhandItem(ItemStack heldItem) {
        Mob mob = (Mob)this;
        AttackHand currentHand = MobAttackHelper.getCurrentAttack((LivingEntity)mob, this.bettermobcombat$comboCount);
        if (currentHand != null) {
            return currentHand.isOffHand() ? mob.m_21206_() : heldItem;
        }
        return heldItem;
    }

    @WrapOperation(method={"doHurtTarget"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;getMainHandItem()Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack wrap_getMainHandItem_doHurtTarget(Mob instance, Operation<ItemStack> original) {
        return this.bettermobcombat$getAlternateMainHandItem(instance, original);
    }

    @Unique
    protected ItemStack bettermobcombat$getAlternateMainHandItem(Mob instance, Operation<ItemStack> original) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)this)) {
            return (ItemStack)original.call(new Object[]{instance});
        }
        if (this.bettermobcombat$comboCount < 0) {
            return (ItemStack)original.call(new Object[]{instance});
        }
        AttackHand hand = MobAttackHelper.getCurrentAttack((LivingEntity)instance, this.bettermobcombat$comboCount);
        if (hand == null) {
            boolean isOffHand = MobAttackHelper.shouldAttackWithOffHand((LivingEntity)instance, this.bettermobcombat$comboCount);
            return isOffHand ? ItemStack.f_41583_ : (ItemStack)original.call(new Object[]{instance});
        }
        this.bettermobcombat$lastAttack = hand;
        return hand.itemStack();
    }

    @Inject(method={"isWithinMeleeAttackRange"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_isWithinMeleeAttackRange(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        MobCombatHelper.onHoldingBetterCombatWeapon((Mob)this, (m, wa) -> {
            AttackHand currentAttack = this.getCurrentAttack();
            if (currentAttack != null) {
                cir.setReturnValue((Object)MobCombatHelper.isWithinAttackRange((LivingEntity)m, (Entity)target, currentAttack.attack(), wa.attackRange()));
            }
        });
    }

    @Override
    public void bettermobcombat$startUpswing(WeaponAttributes attributes, @Nullable BiConsumer<Mob, Entity> customDamageApplicator) {
        AttackHand hand = this.bettermobcombat$getCurrentHand();
        if (hand != null) {
            float upswingRate = (float)MobAttackHelper.getTotalUpswingRate(hand);
            if (this.bettermobcombat$upswingTicks <= 0 && this.bettermobcombat$attackCooldown <= 0 && !this.m_6117_() && !(this.bettercombat$getAttackStrengthScale(0.0f) < 1.0 - (double)upswingRate)) {
                this.bettermobcombat$customDamageApplicator = customDamageApplicator;
                this.m_21253_();
                this.bettermobcombat$lastAttacked = 0;
                this.bettermobcombat$upswingStack = this.m_21205_();
                float attackCooldownTicksFloat = MobAttackHelper.getAttackCooldownTicksCapped((Mob)this);
                int attackCooldownTicks = Math.round(attackCooldownTicksFloat);
                this.bettermobcombat$comboReset = Math.round(attackCooldownTicksFloat * BetterCombat.config.combo_reset_rate);
                this.bettermobcombat$upswingTicks = Math.max(Math.round(attackCooldownTicksFloat * upswingRate), 1);
                this.bettermobcombat$lastSwingDuration = attackCooldownTicksFloat;
                this.bettermobcombat$setAttackCooldown(attackCooldownTicks + BetterMobCombat.getServerConfig().mob_additional_attack_cooldown);
                String animationName = hand.attack().animation();
                boolean isOffHand = hand.isOffHand();
                AnimatedHand animatedHand = AnimatedHand.from((boolean)isOffHand, (boolean)attributes.isTwoHanded());
                Services.PLATFORM.playMobAttackAnimation(this, animatedHand, animationName, attackCooldownTicksFloat, upswingRate);
                BetterMobCombatEvents.ATTACK_START.invoke(handler -> handler.onMobAttackStart((Mob)this, hand));
            }
        } else {
            Constants.LOG.error("Upswing did not start for {} due to lack of AttackHand", (Object)this);
        }
    }

    @Nullable
    public AttackHand getCurrentAttack() {
        if (this.bettermobcombat$comboCount < 0) {
            return null;
        }
        Mob player = (Mob)this;
        return MobAttackHelper.getCurrentAttack((LivingEntity)player, this.bettermobcombat$comboCount);
    }

    @Override
    public float bettermobcombat$getCurrentItemAttackStrengthDelay() {
        double attackSpeed;
        if (this.m_21051_(Attributes.f_22283_) != null) {
            attackSpeed = this.m_21133_(Attributes.f_22283_);
        } else {
            ItemStack activeWeapon = !this.m_9236_().f_46443_ && this.getComboCount() > 0 && MobAttackHelper.shouldAttackWithOffHand(this, this.getComboCount()) ? this.m_21206_() : this.m_21205_();
            Collection speedMods = activeWeapon.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_);
            attackSpeed = MobCombatHelper.calculateAttributeValue(Attributes.f_22283_, Attributes.f_22283_.m_22082_(), speedMods);
        }
        return (float)(1.0 / attackSpeed * 20.0);
    }

    @Override
    public double bettercombat$getAttackStrengthScale(float partialTick) {
        return Mth.m_14036_((float)(((float)this.f_20922_ + partialTick) / this.bettermobcombat$getCurrentItemAttackStrengthDelay()), (float)0.0f, (float)1.0f);
    }

    @Override
    public void bettercombat$resetAttackStrengthTicker() {
        this.f_20922_ = 0;
    }

    @Override
    public int bettermobcombat$getAttackCooldown() {
        return this.bettermobcombat$attackCooldown;
    }

    @Unique
    private void bettermobcombat$setAttackCooldown(int ticks) {
        this.bettermobcombat$attackCooldown = ticks;
    }

    @Override
    public float bettermobcombat$getSwingProgress() {
        return !((float)this.bettermobcombat$lastAttacked > this.bettermobcombat$lastSwingDuration) && !(this.bettermobcombat$lastSwingDuration <= 0.0f) ? (float)this.bettermobcombat$lastAttacked / this.bettermobcombat$lastSwingDuration : 1.0f;
    }

    @Override
    public int bettermobcombat$getUpswingTicks() {
        return this.bettermobcombat$upswingTicks;
    }

    @Override
    public void bettermobcombat$cancelUpswing() {
        if (this.bettermobcombat$upswingTicks > 0) {
            this.bettermobcombat$cancelWeaponSwing();
        }
    }

    @Override
    public void bettermobcombat$setDelayedUpswing(Runnable runnable) {
        if (BetterMobCombat.getServerConfig().mob_begin_attack_delay > 0) {
            this.bettermobcombat$delayedUpswing = runnable;
            this.bettermobcombat$upswingDelay = BetterMobCombat.getServerConfig().mob_begin_attack_delay;
        } else {
            runnable.run();
        }
    }

    @Override
    public boolean bettermobcombat$hasDelayedUpswing() {
        return this.bettermobcombat$delayedUpswing != null;
    }

    public int getComboCount() {
        return this.bettermobcombat$comboCount;
    }

    public void setComboCount(int comboCount) {
        if (!this.m_9236_().f_46443_ && this.bettermobcombat$comboCount != comboCount) {
            Services.PLATFORM.syncMobComboCount(this, comboCount);
        }
        this.bettermobcombat$comboCount = comboCount;
    }

    private /* synthetic */ void lambda$bettermobcombat$performAttack$0(AttackHand hand, List targets, Entity intendedTarget, BetterMobCombatEvents.MobAttackHit handler) {
        handler.onMobAttackHit((Mob)this, hand, targets, intendedTarget);
    }
}

