/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.mixin;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import java.util.List;
import java.util.Optional;
import me.Thelnfamous1.bettermobcombat.BetterMobCombatClient;
import me.Thelnfamous1.bettermobcombat.api.MobAttackAnimation;
import me.Thelnfamous1.bettermobcombat.logic.MobAttackHelper;
import me.Thelnfamous1.bettermobcombat.platform.Services;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.animation.AnimationRegistry;
import net.bettercombat.client.animation.AttackAnimationSubStack;
import net.bettercombat.client.animation.CustomAnimationPlayer;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.animation.PoseSubStack;
import net.bettercombat.client.animation.StateCollectionHelper;
import net.bettercombat.client.animation.modifier.HarshAdjustmentModifier;
import net.bettercombat.client.animation.modifier.TransmissionSpeedModifier;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobMixin_AttackAnimation
extends LivingEntity
implements PlayerAttackAnimatable,
IAnimatedPlayer,
MobAttackAnimation {
    @Unique
    private final AttackAnimationSubStack bettermobcombat$attackAnimation = new AttackAnimationSubStack(this.bettermobcombat$createAttackAdjustment());
    @Unique
    private final PoseSubStack bettermobcombat$mainHandBodyPose = new PoseSubStack((AbstractModifier)this.bettermobcombat$createPoseAdjustment(), true, true);
    @Unique
    private final PoseSubStack bettermobcombat$mainHandItemPose = new PoseSubStack(null, false, true);
    @Unique
    private final PoseSubStack bettermobcombat$offHandBodyPose = new PoseSubStack(null, true, false);
    @Unique
    private final PoseSubStack bettermobcombat$offHandItemPose = new PoseSubStack(null, false, true);

    @Shadow
    public abstract boolean m_21526_();

    protected MobMixin_AttackAnimation(EntityType<? extends Mob> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Unique
    private AdjustmentModifier bettermobcombat$createAttackAdjustment() {
        return new AdjustmentModifier(partName -> {
            float offsetZ;
            float offsetY;
            float offsetX;
            float rotationZ;
            float rotationY;
            float rotationX;
            block20: {
                block19: {
                    rotationX = 0.0f;
                    rotationY = 0.0f;
                    rotationZ = 0.0f;
                    offsetX = 0.0f;
                    offsetY = 0.0f;
                    offsetZ = 0.0f;
                    if (!FirstPersonMode.isFirstPersonPass()) break block19;
                    float pitch = this.m_146909_();
                    pitch = (float)Math.toRadians(pitch);
                    switch (partName) {
                        case "body": {
                            rotationX -= pitch;
                            if (pitch < 0.0f) {
                                double offset = Math.abs(Math.sin(pitch));
                                offsetY = (float)((double)offsetY + offset * 0.5);
                                offsetZ = (float)((double)offsetZ - offset);
                                break;
                            }
                            break block20;
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                    break block20;
                }
                float pitch = this.m_146909_();
                pitch = (float)Math.toRadians(pitch);
                switch (partName) {
                    case "body": {
                        rotationX -= pitch * 0.75f;
                        break;
                    }
                    case "rightArm": 
                    case "leftArm": {
                        rotationX += pitch * 0.25f;
                        break;
                    }
                    case "rightLeg": 
                    case "leftLeg": {
                        rotationX = (float)((double)rotationX - (double)pitch * 0.75);
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    @Unique
    private AdjustmentModifier bettermobcombat$createPoseAdjustment() {
        return new HarshAdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (!FirstPersonMode.isFirstPersonPass()) {
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        if (this.bettermobcombat$mainHandItemPose.lastAnimationUsesBodyChannel || !this.m_6144_()) break;
                        offsetY += 3.0f;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void post_init(EntityType<?> $$0, Level $$1, CallbackInfo ci) {
        AnimationStack stack = this.getAnimationStack();
        stack.addAnimLayer(1, (IAnimation)this.bettermobcombat$offHandItemPose.base);
        stack.addAnimLayer(2, (IAnimation)this.bettermobcombat$offHandBodyPose.base);
        stack.addAnimLayer(3, (IAnimation)this.bettermobcombat$mainHandItemPose.base);
        stack.addAnimLayer(4, (IAnimation)this.bettermobcombat$mainHandBodyPose.base);
        stack.addAnimLayer(2000, (IAnimation)this.bettermobcombat$attackAnimation.base);
        this.bettermobcombat$mainHandBodyPose.configure = this::bettermobcombat$updateAnimationByCurrentActivity;
        this.bettermobcombat$offHandBodyPose.configure = this::bettermobcombat$updateAnimationByCurrentActivity;
    }

    public void updateAnimationsOnTick() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        boolean isLeftHanded = this.m_21526_();
        boolean hasActiveAttackAnimation = this.bettermobcombat$hasActiveAttackAnimation();
        ItemStack mainHandStack = this.m_21205_();
        if (!(this.f_20911_ || this.m_6069_() || this.m_6117_() || Services.PLATFORM.isCastingSpell(this) || CrossbowItem.m_40932_((ItemStack)mainHandStack))) {
            WeaponAttributes offHandAttributes;
            if (hasActiveAttackAnimation) {
                super.m_5632_(this.m_6080_(), 0.0f);
            }
            KeyframeAnimation newMainHandPose = null;
            WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes((ItemStack)mainHandStack);
            if (mainHandAttributes != null && mainHandAttributes.pose() != null) {
                newMainHandPose = (KeyframeAnimation)AnimationRegistry.animations.get(mainHandAttributes.pose());
            }
            KeyframeAnimation newOffHandPose = null;
            if (MobAttackHelper.isDualWielding((LivingEntity)((Mob)this)) && (offHandAttributes = WeaponRegistry.getAttributes((ItemStack)this.m_21206_())) != null && offHandAttributes.offHandPose() != null) {
                newOffHandPose = (KeyframeAnimation)AnimationRegistry.animations.get(offHandAttributes.offHandPose());
            }
            this.bettermobcombat$mainHandItemPose.setPose(newMainHandPose, isLeftHanded);
            this.bettermobcombat$offHandItemPose.setPose(newOffHandPose, isLeftHanded);
            if (!MobAttackHelper.isTwoHandedWielding((LivingEntity)((Mob)this)) && (this.bettermobcombat$isWalking() || this.m_6144_())) {
                newMainHandPose = null;
                newOffHandPose = null;
            }
            this.bettermobcombat$mainHandBodyPose.setPose(newMainHandPose, isLeftHanded);
            this.bettermobcombat$offHandBodyPose.setPose(newOffHandPose, isLeftHanded);
        } else {
            this.bettermobcombat$mainHandBodyPose.setPose(null, isLeftHanded);
            this.bettermobcombat$mainHandItemPose.setPose(null, isLeftHanded);
            this.bettermobcombat$offHandBodyPose.setPose(null, isLeftHanded);
            this.bettermobcombat$offHandItemPose.setPose(null, isLeftHanded);
        }
    }

    @Override
    public boolean bettermobcombat$hasActiveAttackAnimation() {
        return this.bettermobcombat$attackAnimation.base.getAnimation() != null && this.bettermobcombat$attackAnimation.base.getAnimation().isActive();
    }

    @Override
    public boolean bettermobcombat$hasActiveMainHandItemPose() {
        return this.bettermobcombat$mainHandItemPose.base.getAnimation() != null && this.bettermobcombat$mainHandItemPose.base.getAnimation().isActive();
    }

    @Override
    public boolean bettermobcombat$hasActiveOffHandItemPose() {
        return this.bettermobcombat$offHandItemPose.base.getAnimation() != null && this.bettermobcombat$offHandItemPose.base.getAnimation().isActive();
    }

    @Override
    public boolean bettermobcombat$hasActiveMainHandBodyPose() {
        return this.bettermobcombat$mainHandBodyPose.base.getAnimation() != null && this.bettermobcombat$mainHandBodyPose.base.getAnimation().isActive();
    }

    @Override
    public boolean bettermobcombat$hasActiveOffHandBodyPose() {
        return this.bettermobcombat$offHandBodyPose.base.getAnimation() != null && this.bettermobcombat$offHandBodyPose.base.getAnimation().isActive();
    }

    @Unique
    private boolean bettermobcombat$isWalking() {
        return !this.m_21224_() && (this.m_6069_() || this.m_20184_().m_165924_() > 0.03);
    }

    public void playAttackAnimation(String name, AnimatedHand animatedHand, float length, float upswing) {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        try {
            KeyframeAnimation animation = (KeyframeAnimation)AnimationRegistry.animations.get(name);
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.bettermobcombat$updateAnimationByCurrentActivity(copy);
            copy.torso.fullyEnablePart(true);
            copy.head.pitch.setEnabled(false);
            float speed = (float)animation.endTick / length;
            boolean mirror = animatedHand.isOffHand();
            if (this.m_21526_()) {
                mirror = !mirror;
            }
            int fadeIn = copy.beginTick;
            float upswingMultiplier = (float)MobAttackHelper.getTotalUpswingMultiplier();
            float upswingSpeed = speed / upswingMultiplier;
            float downwindSpeed = (float)((double)speed * Mth.m_14139_((double)(Math.max((double)upswingMultiplier - 0.5, 0.0) / 0.5), (double)(1.0f - upswing), (double)(upswing / (1.0f - upswing))));
            this.bettermobcombat$attackAnimation.speed.set(upswingSpeed, List.of(new TransmissionSpeedModifier.Gear(length * upswing, downwindSpeed), new TransmissionSpeedModifier.Gear(length, speed)));
            this.bettermobcombat$attackAnimation.mirror.setEnabled(mirror);
            CustomAnimationPlayer player = new CustomAnimationPlayer(copy.build(), 0);
            player.setFirstPersonMode(CompatibilityFlags.firstPersonRender() ? FirstPersonMode.THIRD_PERSON_MODEL : FirstPersonMode.NONE);
            player.setFirstPersonConfiguration(this.bettermobcombat$firstPersonConfig(animatedHand));
            this.bettermobcombat$attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Unique
    private FirstPersonConfiguration bettermobcombat$firstPersonConfig(AnimatedHand animatedHand) {
        boolean showRightItem = true;
        boolean showLeftItem = BetterMobCombatClient.getBetterCombatClientConfig().isShowingOtherHandFirstPerson || animatedHand == AnimatedHand.TWO_HANDED;
        boolean showRightArm = showRightItem && BetterMobCombatClient.getBetterCombatClientConfig().isShowingArmsInFirstPerson;
        boolean showLeftArm = showLeftItem && BetterMobCombatClient.getBetterCombatClientConfig().isShowingArmsInFirstPerson;
        FirstPersonConfiguration config = new FirstPersonConfiguration(showRightArm, showLeftArm, showRightItem, showLeftItem);
        return config;
    }

    @Unique
    private void bettermobcombat$updateAnimationByCurrentActivity(KeyframeAnimation.AnimationBuilder animation) {
        Pose pose = this.m_20089_();
        switch (pose) {
            case SWIMMING: {
                StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.rightLeg, (boolean)false, (boolean)false);
                StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.leftLeg, (boolean)false, (boolean)false);
            }
        }
        if (this.bettermobcombat$isMounting()) {
            StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.rightLeg, (boolean)false, (boolean)false);
            StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.leftLeg, (boolean)false, (boolean)false);
        }
    }

    @Unique
    private boolean bettermobcombat$isMounting() {
        return this.m_20202_() != null;
    }

    public void stopAttackAnimation(float length) {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        IAnimation currentAnimation = this.bettermobcombat$attackAnimation.base.getAnimation();
        if (currentAnimation != null && currentAnimation instanceof KeyframeAnimationPlayer) {
            int fadeOut = Math.round(length);
            this.bettermobcombat$attackAnimation.adjustmentModifier.fadeOut(fadeOut);
            this.bettermobcombat$attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeOut, (Ease)Ease.INOUTSINE), null);
        }
    }
}

