/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.logic;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.Thelnfamous1.bettermobcombat.api.MobAttackRangeExtensions;
import me.Thelnfamous1.bettermobcombat.logic.MobTargetHelper;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.client.AttackRangeExtensions;
import net.bettercombat.client.collision.CollisionHelper;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.client.collision.WeaponHitBoxes;
import net.bettercombat.logic.TargetHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MobTargetFinder {
    @Nullable
    public static LivingEntity getAttackTarget(Mob mob) {
        LivingEntity target = mob.m_5448_();
        if (target != null) {
            return target;
        }
        Optional attackTarget = mob.m_6274_().m_257414_(MemoryModuleType.f_26372_);
        if (attackTarget != null && attackTarget.isPresent()) {
            return (LivingEntity)attackTarget.get();
        }
        return null;
    }

    public static TargetFinder.TargetResult findAttackTargetResult(LivingEntity mob, @Nullable Entity intendedTarget, WeaponAttributes.Attack attack, double attackRange) {
        Vec3 origin = MobTargetFinder.getInitialTracingPoint(mob);
        List<Entity> entities = MobTargetFinder.getInitialTargets(mob, intendedTarget, attackRange);
        if (!MobAttackRangeExtensions.sources().isEmpty()) {
            attackRange = MobTargetFinder.applyAttackRangeModifiers(mob, attackRange);
        }
        boolean isSpinAttack = attack.angle() > 180.0;
        Vec3 size = WeaponHitBoxes.createHitbox((WeaponAttributes.HitBoxShape)attack.hitbox(), (double)attackRange, (boolean)isSpinAttack);
        OrientedBoundingBox obb = new OrientedBoundingBox(origin, size, mob.m_146909_(), mob.m_146908_());
        if (!isSpinAttack) {
            obb = obb.offsetAlongAxisZ(size.f_82481_ / 2.0);
        }
        obb.updateVertex();
        CollisionFilter collisionFilter = new CollisionFilter(obb);
        entities = collisionFilter.filter(entities, mob);
        RadialFilter radialFilter = new RadialFilter(origin, obb.axisZ, attackRange, attack.angle());
        entities = radialFilter.filter(entities, mob);
        return new TargetFinder.TargetResult(entities, obb);
    }

    public static double applyAttackRangeModifiers(LivingEntity mob, double attackRange) {
        MobAttackRangeExtensions.Context context = new MobAttackRangeExtensions.Context(mob, attackRange);
        List<AttackRangeExtensions.Modifier> modifiers = MobAttackRangeExtensions.sources().stream().map(function -> (AttackRangeExtensions.Modifier)function.apply(context)).sorted(Comparator.comparingInt(AttackRangeExtensions.Modifier::operationOrder)).toList();
        double result = attackRange;
        for (AttackRangeExtensions.Modifier modifier : modifiers) {
            switch (modifier.operation()) {
                case ADD: {
                    result += modifier.value();
                    break;
                }
                case MULTIPLY: {
                    result *= modifier.value();
                }
            }
        }
        return result;
    }

    public static List<Entity> findAttackTargets(LivingEntity mob, @Nullable Entity intendedTarget, WeaponAttributes.Attack attack, double attackRange) {
        return MobTargetFinder.findAttackTargetResult((LivingEntity)mob, (Entity)intendedTarget, (WeaponAttributes.Attack)attack, (double)attackRange).entities;
    }

    public static Vec3 getInitialTracingPoint(LivingEntity mob) {
        double shoulderHeight = (double)mob.m_20206_() * 0.15 * (double)mob.m_6134_();
        return mob.m_146892_().m_82492_(0.0, shoulderHeight, 0.0);
    }

    public static List<Entity> getInitialTargets(LivingEntity mob, @Nullable Entity intendedTarget, double attackRange) {
        AABB box = mob.m_20191_().m_82400_(attackRange * (double)BetterCombat.config.target_search_range_multiplier + 1.0);
        List detectedEntities = mob.m_9236_().m_6249_((Entity)mob, box, entity -> !entity.m_5833_() && entity.m_6087_());
        List<Entity> targetableEntities = detectedEntities.stream().filter(entity -> entity != mob && entity != intendedTarget && entity.m_6097_() && (!entity.equals((Object)mob.m_20202_()) || TargetHelper.isAttackableMount((Entity)entity)) && MobTargetHelper.getRelation(mob, entity) == TargetHelper.Relation.HOSTILE).collect(Collectors.toList());
        if (intendedTarget != null && detectedEntities.contains(intendedTarget)) {
            targetableEntities.add(intendedTarget);
        }
        return targetableEntities;
    }

    public static class CollisionFilter
    implements Filter {
        private final OrientedBoundingBox obb;

        public CollisionFilter(OrientedBoundingBox obb) {
            this.obb = obb;
        }

        @Override
        public boolean test(Entity target, LivingEntity mob) {
            return this.obb.intersects(target.m_20191_().m_82400_((double)target.m_6143_())) || this.obb.contains(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0));
        }
    }

    public static class RadialFilter
    implements Filter {
        private final Vec3 origin;
        private final Vec3 orientation;
        private final double attackRange;
        private final double attackAngle;

        public RadialFilter(Vec3 origin, Vec3 orientation, double attackRange, double attackAngle) {
            this.origin = origin;
            this.orientation = orientation;
            this.attackRange = attackRange;
            this.attackAngle = Mth.m_14008_((double)attackAngle, (double)0.0, (double)360.0);
        }

        @Override
        public boolean test(Entity target, LivingEntity mob) {
            double maxAngleDif = this.attackAngle / 2.0;
            Vec3 distanceVector = CollisionHelper.distanceVector((Vec3)this.origin, (AABB)target.m_20191_());
            Vec3 positionVector = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(this.origin);
            return distanceVector.m_82553_() <= this.attackRange && (this.attackAngle == 0.0 || CollisionHelper.angleBetween((Vec3)positionVector, (Vec3)this.orientation) <= maxAngleDif || CollisionHelper.angleBetween((Vec3)distanceVector, (Vec3)this.orientation) <= maxAngleDif) && (BetterCombat.config.allow_attacking_thru_walls || RadialFilter.rayContainsNoObstacle(this.origin, this.origin.m_82549_(distanceVector), mob) || RadialFilter.rayContainsNoObstacle(this.origin, this.origin.m_82549_(positionVector), mob));
        }

        private static boolean rayContainsNoObstacle(Vec3 start, Vec3 end, LivingEntity mob) {
            BlockHitResult hit = mob.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob));
            return hit.m_6662_() != HitResult.Type.BLOCK;
        }
    }

    public static interface Filter
    extends BiPredicate<Entity, LivingEntity> {
        default public List<Entity> filter(List<Entity> targets, LivingEntity mob) {
            return targets.stream().filter(target -> this.test(target, mob)).collect(Collectors.toList());
        }
    }
}

