/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.logic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.Thelnfamous1.bettermobcombat.BetterMobCombat;
import me.Thelnfamous1.bettermobcombat.Constants;
import me.Thelnfamous1.bettermobcombat.api.MobAttackRangeExtensions;
import me.Thelnfamous1.bettermobcombat.api.MobAttackWindup;
import me.Thelnfamous1.bettermobcombat.logic.MobAttackHelper;
import me.Thelnfamous1.bettermobcombat.logic.MobSoundHelper;
import me.Thelnfamous1.bettermobcombat.logic.MobTargetFinder;
import me.Thelnfamous1.bettermobcombat.mixin.MobAccessor;
import me.Thelnfamous1.bettermobcombat.mixin.ServerNetworkAccessor;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.WeaponHitBoxes;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.TargetHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.logic.knockback.ConfigurableKnockback;
import net.bettercombat.mixin.LivingEntityAccessor;
import net.bettercombat.utils.MathHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MobCombatHelper {
    public static ItemStack getDirectMainhand(Mob mob) {
        return (ItemStack)((MobAccessor)mob).bettermobcombat$getHandItems().get(EquipmentSlot.MAINHAND.m_20749_());
    }

    public static ItemStack getDirectOffhand(Mob mob) {
        return (ItemStack)((MobAccessor)mob).bettermobcombat$getHandItems().get(EquipmentSlot.OFFHAND.m_20749_());
    }

    public static void onHoldingBetterCombatWeapon(Mob mob, BiConsumer<Mob, WeaponAttributes> callback) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)mob)) {
            return;
        }
        WeaponAttributes attributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21205_());
        if (attributes != null && attributes.attacks() != null) {
            callback.accept(mob, attributes);
        }
    }

    public static boolean canUseBetterCombatWeapon(Mob mob, BiPredicate<Mob, WeaponAttributes> predicate) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)mob)) {
            return false;
        }
        WeaponAttributes attributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21205_());
        if (attributes != null && attributes.attacks() != null) {
            return predicate.test(mob, attributes);
        }
        return false;
    }

    public static <T> T applyWithBetterCombatWeapon(Mob mob, BiFunction<Mob, WeaponAttributes, T> function, Supplier<T> defaultValue) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)mob)) {
            return defaultValue.get();
        }
        WeaponAttributes attributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21205_());
        if (attributes != null && attributes.attacks() != null) {
            return function.apply(mob, attributes);
        }
        return defaultValue.get();
    }

    public static void processAttack(Level world, Mob mob, int comboCount, List<Entity> targets, @Nullable BiConsumer<Mob, Entity> damageApplicator) {
        if (world != null && !world.f_46443_) {
            AttackHand hand = MobAttackHelper.getCurrentAttack((LivingEntity)mob, comboCount);
            if (hand == null) {
                Constants.LOG.error("Server handling attack for {} - No current attack hand!", (Object)mob);
                Constants.LOG.error("Combo count: " + comboCount + " is dual wielding: " + MobAttackHelper.isDualWielding((LivingEntity)mob));
                Constants.LOG.error("Main-hand stack: " + mob.m_21205_());
                Constants.LOG.error("Off-hand stack: " + mob.m_21206_());
            } else {
                WeaponAttributes.Attack attack = hand.attack();
                WeaponAttributes attributes = hand.attributes();
                world.m_7654_().m_201446_(() -> {
                    int sweepingLevel;
                    ((PlayerAttackProperties)mob).setComboCount(comboCount);
                    HashMultimap comboAttributes = null;
                    HashMultimap dualWieldingAttributes = null;
                    HashMultimap sweepingModifiers = HashMultimap.create();
                    if (attributes != null && attack != null) {
                        comboAttributes = HashMultimap.create();
                        double comboMultiplier = attack.damageMultiplier() - 1.0;
                        comboAttributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ServerNetworkAccessor.bettermobcombat$getCOMBO_DAMAGE_MODIFIER_ID(), "COMBO_DAMAGE_MULTIPLIER", comboMultiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                        mob.m_21204_().m_22178_((Multimap)comboAttributes);
                        float dualWieldingMultiplier = MobAttackHelper.getDualWieldingAttackDamageMultiplier((LivingEntity)mob, hand) - 1.0f;
                        if (dualWieldingMultiplier != 0.0f) {
                            dualWieldingAttributes = HashMultimap.create();
                            dualWieldingAttributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ServerNetworkAccessor.bettermobcombat$getDUAL_WIELDING_MODIFIER_ID(), "DUAL_WIELDING_DAMAGE_MULTIPLIER", (double)dualWieldingMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                            mob.m_21204_().m_22178_((Multimap)dualWieldingAttributes);
                        }
                        if (hand.isOffHand()) {
                            MobAttackHelper.setAttributesForOffHandAttack((LivingEntity)mob, true);
                        }
                        MobSoundHelper.playSound((ServerLevel)world, (Entity)mob, attack.swingSound());
                        if (BetterCombat.config.allow_reworked_sweeping && targets.size() > 1) {
                            boolean playEffects;
                            double multiplier = 1.0 - (double)(BetterCombat.config.reworked_sweeping_maximum_damage_penalty / (float)BetterCombat.config.reworked_sweeping_extra_target_count * (float)Math.min(BetterCombat.config.reworked_sweeping_extra_target_count, targets.size() - 1));
                            sweepingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)hand.itemStack());
                            double sweepingSteps = (double)BetterCombat.config.reworked_sweeping_enchant_restores / (double)Enchantments.f_44983_.m_6586_();
                            multiplier += (double)sweepingLevel * sweepingSteps;
                            multiplier = Math.min(multiplier, 1.0);
                            sweepingModifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ServerNetworkAccessor.bettermobcombat$getSWEEPING_MODIFIER_ID(), "SWEEPING_DAMAGE_MODIFIER", multiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                            mob.m_21204_().m_22178_((Multimap)sweepingModifiers);
                            boolean bl = playEffects = !BetterCombat.config.reworked_sweeping_sound_and_particles_only_for_swords || hand.itemStack().m_41720_() instanceof SwordItem;
                            if (BetterCombat.config.reworked_sweeping_plays_sound && playEffects) {
                                world.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_12317_, mob.m_5720_(), 1.0f, 1.0f);
                            }
                            if (BetterCombat.config.reworked_sweeping_emits_particles && playEffects) {
                                MobCombatHelper.sweepAttack(mob);
                            }
                        }
                    }
                    float attackCooldown = MobAttackHelper.getAttackCooldownTicksCapped(mob);
                    float knockbackMultiplier = BetterCombat.config.knockback_reduced_for_fast_attacks ? MathHelper.clamp((float)(attackCooldown / 12.5f), (float)0.1f, (float)1.0f) : 1.0f;
                    int lastAttackedTicks = ((LivingEntityAccessor)mob).getLastAttackedTicks();
                    for (sweepingLevel = 0; sweepingLevel < targets.size(); ++sweepingLevel) {
                        LivingEntity livingTarget;
                        Entity target = (Entity)targets.get(sweepingLevel);
                        if (target == null || target.equals((Object)mob.m_20202_()) && !TargetHelper.isAttackableMount((Entity)target) || target instanceof ArmorStand && ((ArmorStand)target).m_31677_()) continue;
                        LivingEntity livingEntity = livingTarget = target instanceof LivingEntity ? (LivingEntity)target : null;
                        if (livingTarget != null) {
                            if (BetterCombat.config.allow_fast_attacks) {
                                livingTarget.f_19802_ = 0;
                            }
                            if (knockbackMultiplier != 1.0f) {
                                ((ConfigurableKnockback)livingTarget).setKnockbackMultiplier_BetterCombat(knockbackMultiplier);
                            }
                        }
                        ((LivingEntityAccessor)mob).setLastAttackedTicks(lastAttackedTicks);
                        if (target instanceof ItemEntity || target instanceof ExperienceOrb || target instanceof AbstractArrow || target == mob) {
                            Constants.LOG.error("{} tried to attack an invalid entity - {}", (Object)mob.m_7755_().getString(), (Object)target);
                            return;
                        }
                        if (damageApplicator != null) {
                            damageApplicator.accept(mob, target);
                        } else {
                            mob.m_7327_(target);
                        }
                        if (livingTarget == null || knockbackMultiplier == 1.0f) continue;
                        ((ConfigurableKnockback)livingTarget).setKnockbackMultiplier_BetterCombat(1.0f);
                    }
                    mob.m_21310_(0);
                    if (comboAttributes != null) {
                        mob.m_21204_().m_22161_((Multimap)comboAttributes);
                        if (hand.isOffHand()) {
                            MobAttackHelper.setAttributesForOffHandAttack((LivingEntity)mob, false);
                        }
                    }
                    if (dualWieldingAttributes != null) {
                        mob.m_21204_().m_22161_(dualWieldingAttributes);
                    }
                    if (!sweepingModifiers.isEmpty()) {
                        mob.m_21204_().m_22161_((Multimap)sweepingModifiers);
                    }
                });
            }
        }
    }

    public static void sweepAttack(Mob mob) {
        double xOffset = -Mth.m_14031_((float)(mob.m_146908_() * ((float)Math.PI / 180)));
        double zOffset = Mth.m_14089_((float)(mob.m_146908_() * ((float)Math.PI / 180)));
        if (mob.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, mob.m_20185_() + xOffset, mob.m_20227_(0.5), mob.m_20189_() + zOffset, 0, xOffset, 0.0, zOffset, 0.0);
        }
    }

    public static double calculateAttributeValue(Attribute attribute, double baseValue, Collection<AttributeModifier> modifiers) {
        double sumValue = baseValue;
        for (AttributeModifier additive : modifiers.stream().filter(mod -> mod.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)).toList()) {
            sumValue += additive.m_22218_();
        }
        double productValue = sumValue;
        for (AttributeModifier baseMultiplicative : modifiers.stream().filter(mod -> mod.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_BASE)).toList()) {
            productValue += sumValue * baseMultiplicative.m_22218_();
        }
        for (AttributeModifier totalMultiplicative : modifiers.stream().filter(mod -> mod.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_TOTAL)).toList()) {
            productValue *= 1.0 + totalMultiplicative.m_22218_();
        }
        return attribute.m_6740_(productValue);
    }

    public static boolean isWithinAttackRange(LivingEntity mob, Entity target, WeaponAttributes.Attack attack, double attackRange) {
        Vec3 origin = MobTargetFinder.getInitialTracingPoint(mob);
        if (!MobAttackRangeExtensions.sources().isEmpty()) {
            attackRange = MobTargetFinder.applyAttackRangeModifiers(mob, attackRange);
        }
        boolean isSpinAttack = attack.angle() > 180.0;
        Vec3 size = WeaponHitBoxes.createHitbox((WeaponAttributes.HitBoxShape)attack.hitbox(), (double)(attackRange *= (double)BetterMobCombat.getServerConfig().mob_begin_attack_range_multiplier), (boolean)isSpinAttack);
        OrientedBoundingBox obb = new OrientedBoundingBox(origin, size, mob.m_146909_(), mob.m_146908_());
        if (!isSpinAttack) {
            obb = obb.offsetAlongAxisZ(size.f_82481_ / 2.0);
        }
        obb.updateVertex();
        return new MobTargetFinder.CollisionFilter(obb).and(new MobTargetFinder.RadialFilter(origin, obb.axisZ, attackRange, attack.angle())).test(target, mob);
    }

    public static boolean isAttackReady(Mob mob) {
        return !((MobAttackWindup)mob).bettermobcombat$hasDelayedUpswing() && ((MobAttackWindup)mob).bettermobcombat$getAttackCooldown() <= 0;
    }

    public static void setDelayedUpswing(Mob mob, Runnable runnable) {
        ((MobAttackWindup)mob).bettermobcombat$setDelayedUpswing(runnable);
    }
}

