/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.logic;

import java.util.Arrays;
import me.Thelnfamous1.bettermobcombat.BetterMobCombat;
import me.Thelnfamous1.bettermobcombat.api.MobAttackStrength;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.ComboState;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import org.jetbrains.annotations.Nullable;

public class MobAttackHelper {
    private static final Object attributesLock = new Object();

    public static float getDualWieldingAttackDamageMultiplier(LivingEntity mob, AttackHand hand) {
        return MobAttackHelper.isDualWielding(mob) ? (hand.isOffHand() ? BetterCombat.config.dual_wielding_off_hand_damage_multiplier : BetterCombat.config.dual_wielding_main_hand_damage_multiplier) : 1.0f;
    }

    public static boolean shouldAttackWithOffHand(LivingEntity mob, int comboCount) {
        return MobAttackHelper.isDualWielding(mob) && comboCount % 2 == 1;
    }

    public static boolean isDualWielding(LivingEntity mob) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)mob)) {
            return false;
        }
        WeaponAttributes mainAttributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21205_());
        WeaponAttributes offAttributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21206_());
        return mainAttributes != null && !mainAttributes.isTwoHanded() && offAttributes != null && !offAttributes.isTwoHanded();
    }

    public static boolean isTwoHandedWielding(LivingEntity mob) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)mob)) {
            return false;
        }
        WeaponAttributes mainAttributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21205_());
        return mainAttributes != null && mainAttributes.isTwoHanded();
    }

    public static float getAttackCooldownTicksCapped(Mob mob) {
        return Math.max(((MobAttackStrength)mob).bettermobcombat$getCurrentItemAttackStrengthDelay(), (float)BetterCombat.config.attack_interval_cap);
    }

    @Nullable
    public static AttackHand getCurrentAttack(LivingEntity mob, int comboCount) {
        if (BetterMobCombat.getServerConfigHelper().isBlacklistedForBetterCombat((Entity)mob)) {
            return null;
        }
        if (MobAttackHelper.isDualWielding(mob)) {
            boolean isOffHand = MobAttackHelper.shouldAttackWithOffHand(mob, comboCount);
            ItemStack itemStack = isOffHand ? mob.m_21206_() : mob.m_21205_();
            WeaponAttributes attributes = WeaponRegistry.getAttributes((ItemStack)itemStack);
            if (attributes != null && attributes.attacks() != null) {
                int handSpecificComboCount = (isOffHand && comboCount > 0 ? comboCount - 1 : comboCount) / 2;
                AttackSelection attackSelection = MobAttackHelper.selectAttack(handSpecificComboCount, attributes, mob, isOffHand);
                WeaponAttributes.Attack attack = attackSelection.attack;
                ComboState combo = attackSelection.comboState;
                return new AttackHand(attack, combo, isOffHand, attributes, itemStack);
            }
        } else {
            ItemStack itemStack = mob.m_21205_();
            WeaponAttributes attributes = WeaponRegistry.getAttributes((ItemStack)itemStack);
            if (attributes != null && attributes.attacks() != null) {
                AttackSelection attackSelection = MobAttackHelper.selectAttack(comboCount, attributes, mob, false);
                WeaponAttributes.Attack attack = attackSelection.attack;
                ComboState combo = attackSelection.comboState;
                return new AttackHand(attack, combo, false, attributes, itemStack);
            }
        }
        return null;
    }

    private static AttackSelection selectAttack(int comboCount, WeaponAttributes attributes, LivingEntity mob, boolean isOffHandAttack) {
        WeaponAttributes.Attack[] attacks = attributes.attacks();
        attacks = (WeaponAttributes.Attack[])Arrays.stream(attacks).filter(attack -> attack.conditions() == null || attack.conditions().length == 0 || MobAttackHelper.evaluateConditions(attack.conditions(), mob, isOffHandAttack)).toArray(WeaponAttributes.Attack[]::new);
        if (comboCount < 0) {
            comboCount = 0;
        }
        int index = comboCount % attacks.length;
        return new AttackSelection(attacks[index], new ComboState(index + 1, attacks.length));
    }

    private static boolean evaluateConditions(WeaponAttributes.Condition[] conditions, LivingEntity mob, boolean isOffHandAttack) {
        return Arrays.stream(conditions).allMatch(condition -> MobAttackHelper.evaluateCondition(condition, mob, isOffHandAttack));
    }

    private static boolean evaluateCondition(WeaponAttributes.Condition condition, LivingEntity mob, boolean isOffHandAttack) {
        if (condition == null) {
            return true;
        }
        switch (condition) {
            case NOT_DUAL_WIELDING: {
                return !MobAttackHelper.isDualWielding(mob);
            }
            case DUAL_WIELDING_ANY: {
                return MobAttackHelper.isDualWielding(mob);
            }
            case DUAL_WIELDING_SAME: {
                return MobAttackHelper.isDualWielding(mob) && mob.m_21205_().m_41720_() == mob.m_21206_().m_41720_();
            }
            case DUAL_WIELDING_SAME_CATEGORY: {
                if (!MobAttackHelper.isDualWielding(mob)) {
                    return false;
                }
                WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21205_());
                WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes((ItemStack)mob.m_21206_());
                if (mainHandAttributes.category() != null && !mainHandAttributes.category().isEmpty() && offHandAttributes.category() != null && !offHandAttributes.category().isEmpty()) {
                    return mainHandAttributes.category().equals(offHandAttributes.category());
                }
                return false;
            }
            case NO_OFFHAND_ITEM: {
                ItemStack offhandStack = mob.m_21206_();
                return offhandStack == null || offhandStack.m_41619_();
            }
            case OFF_HAND_SHIELD: {
                ItemStack offhandStack = mob.m_21206_();
                return offhandStack != null || offhandStack.m_41720_() instanceof ShieldItem;
            }
            case MAIN_HAND_ONLY: {
                return !isOffHandAttack;
            }
            case OFF_HAND_ONLY: {
                return isOffHandAttack;
            }
            case MOUNTED: {
                return mob.m_20202_() != null;
            }
            case NOT_MOUNTED: {
                return mob.m_20202_() == null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void offhandAttributes(LivingEntity mob, Runnable runnable) {
        Object object = attributesLock;
        synchronized (object) {
            MobAttackHelper.setAttributesForOffHandAttack(mob, true);
            runnable.run();
            MobAttackHelper.setAttributesForOffHandAttack(mob, false);
        }
    }

    public static void setAttributesForOffHandAttack(LivingEntity mob, boolean useOffHand) {
        ItemStack add;
        ItemStack remove;
        ItemStack mainHandStack = mob.m_21205_();
        ItemStack offHandStack = mob.m_21206_();
        if (useOffHand) {
            remove = mainHandStack;
            add = offHandStack;
        } else {
            remove = offHandStack;
            add = mainHandStack;
        }
        if (remove != null) {
            mob.m_21204_().m_22161_(remove.m_41638_(EquipmentSlot.MAINHAND));
        }
        if (add != null) {
            mob.m_21204_().m_22178_(add.m_41638_(EquipmentSlot.MAINHAND));
        }
    }

    public static double getTotalUpswingRate(AttackHand hand) {
        double additionalUpswingRate = Mth.m_14008_((double)hand.attack().upswing(), (double)0.0, (double)1.0) * (double)BetterMobCombat.getServerConfig().mob_additional_upswing_multiplier;
        return Mth.m_14008_((double)(hand.upswingRate() + additionalUpswingRate), (double)0.2, (double)1.0);
    }

    public static double getTotalUpswingMultiplier() {
        return Mth.m_14008_((double)(BetterCombat.config.getUpswingMultiplier() + BetterMobCombat.getServerConfig().mob_additional_upswing_multiplier), (double)0.2, (double)1.0);
    }

    private record AttackSelection(WeaponAttributes.Attack attack, ComboState comboState) {
    }
}

