/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.LinkedHashMap;
import me.Thelnfamous1.bettermobcombat.config.BMCServerConfigHelper;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.bettercombat.logic.TargetHelper;
import net.minecraft.Util;

@Config(name="server")
public class BMCServerConfig
implements ConfigData {
    private static final Gson GSON = new Gson();
    @Comment(value="The additional attack cooldown applied to a mob, in ticks, after it launches a Better Combat attack. \nIn vanilla, there is usually a delay of 20 ticks between a mob's attacks. \n7 was chosen because a default Better Combat sword attack takes 13 ticks.")
    @ConfigEntry.BoundedDiscrete(max=100L)
    public int mob_additional_attack_cooldown = 7;
    @Comment(value="The amount of ticks before a mob will launch a Better Combat attack when they are ready to do so.")
    @ConfigEntry.BoundedDiscrete(max=100L)
    public int mob_begin_attack_delay = 10;
    @Comment(value="The amount to add to the \"upswing_multiplier\" config value when calculating a mob's Better Combat attack upswing.  \nA value of 0.0 means the upswing will be at normal speed. \nA value of 0.5 means the upswing will be 50% longer. \nNOTE: The total upswing multiplier will be clamped between 0.2 and 1.0.")
    public float mob_additional_upswing_multiplier = 0.0f;
    @Comment(value="The amount to scale a mob's attack range by when determining when they should launch a Better Combat attack. \nA value of 0.5 means attack swings are triggered when the target is up to 50% of the attack range away from the mob. \nA value of 1 means attack swings are triggered when the target is up to the full attack range away from the mob. \nNOTE: This does not affect the range of the mob's attack during the point of damage application.")
    public float mob_begin_attack_range_multiplier = 1.0f;
    @Comment(value="Controls which mobs are blacklisted from using the Better Combat system. \nHelpful if certain mobs aren't able to properly animate Better Combat attacks.")
    public String[] mob_blacklist = new String[]{"minecraft:fox"};
    @Comment(value="Allows the mob blacklist to instead be used as a whitelist. \nThis makes it so that only mobs in the whitelist can use the Better Combat system.")
    public boolean mob_blacklist_as_whitelist = false;
    @Comment(value="Automatically blacklists mobs detected to be using a GeckoLib model from using the Better Combat system. \nGeckoLib models are not supported by Mob Player Animator, and therefore won't animate Better Combat attacks.")
    public boolean geckolib_mobs_blacklisted = true;
    @Comment(value="Determines if mobs that are assigned to scoreboard teams will only respect scoreboard team ally checks and ignore any other checks.")
    public boolean team_mobs_only_respect_teams = false;
    @Comment(value="Allows mobs to perform the vanilla check for allies. This allows for certain mobs, such as Illagers, to recognize each other as natural allies. \nIf this check fails or is disabled, the system will move on to entity type checks.")
    public boolean mobs_check_for_vanilla_allies = true;
    @Comment(value="Allows mobs to check if they are the same entity type as the target. This allows for mobs with identical entity types (such as two Zombified Piglins) to recognize each other as natural allies. \nIf this check fails or is disabled, the system will move on to mob type checks.")
    public boolean mobs_check_for_same_entity_type = true;
    @Comment(value="Allows mobs to check if they are the same mob type as the target. This allows for mobs with identical mob types (such as two Undead) to recognize each other as natural allies. \nIf this check fails or is disabled, the system will move on to Better Mob Combat target relation checks.")
    public boolean mobs_check_for_same_mob_type = true;
    @Comment(value="Relations determine when mobs' undirected weapon swings (cleaves) will hurt another entity (target).\n- `FRIENDLY` - The target can never be damaged by the mob.\n- `NEUTRAL` - The target can be damaged only if the mob is directly targeting it.\n- `HOSTILE` - The target can be damaged if located within the weapon swing area.\n(NOTE: Vanilla sweeping can still hit targets, if not disabled via `allow_sweeping`)\n\nThe various relation related configs are being checked in the following order:\n- `mob_relations`\n- `mob_relations_to_passives`\n- `mob_relations_to_hostiles`\n- `mob_relations_to_other`\n(The first relation to be found for the target will be applied. If no relation is found, it will default to HOSTILE.)\nRefer to the wiki for formatting instructions: https://github.com/Thelnfamous1/Better-Mob-Combat/wiki/Mob-Relations. \n\nUse a JSON validator such as https://jsonlint.com/ to ensure your JSON strings are correct.\n")
    public LinkedHashMap<String, String> mob_relations = new LinkedHashMap<String, String>(){
        {
            this.put("guardvillagers:guard", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultVillagerAllyRelations)));
            this.put("recruits:recruit", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultVillagerAllyRelations)));
            this.put("recruits:bowman", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultVillagerAllyRelations)));
            this.put("recruits:recruit_shieldman", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultVillagerAllyRelations)));
            this.put("recruits:nomad", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultVillagerAllyRelations)));
            this.put("recruits:horseman", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultVillagerAllyRelations)));
            this.put("minecraft:piglin", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultPiglinRelations)));
            this.put("minecraft:piglin_brute", BMCServerConfig.encodeMobRelationMap((LinkedHashMap)Util.m_137469_(new LinkedHashMap(), BMCServerConfig::addDefaultPiglinRelations)));
        }
    };
    @Comment(value="Relation to unspecified entities that are instances of PassiveEntity(Yarn)/AgeableEntity(Mojmap)")
    public LinkedHashMap<String, TargetHelper.Relation> mob_relations_to_passives = new LinkedHashMap();
    @Comment(value="Relation to unspecified entities that are instances of HostileEntity(Yarn)/MonsterEntity(Mojmap)")
    public LinkedHashMap<String, TargetHelper.Relation> mob_relations_to_hostiles = new LinkedHashMap();
    @Comment(value="Fallback relation")
    public LinkedHashMap<String, TargetHelper.Relation> mob_relations_to_other = new LinkedHashMap();

    private static String encodeMobRelationMap(LinkedHashMap<String, TargetHelper.Relation> input) {
        return ((JsonElement)BMCServerConfigHelper.MOB_RELATIONS_STRING_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, input).result().get()).toString();
    }

    private static void addDefaultVillagerAllyRelations(LinkedHashMap<String, TargetHelper.Relation> map) {
        map.put("guardvillagers:guard", TargetHelper.Relation.NEUTRAL);
        map.put("minecraft:villager", TargetHelper.Relation.NEUTRAL);
        map.put("minecraft:iron_golem", TargetHelper.Relation.NEUTRAL);
        map.put("recruits:recruit", TargetHelper.Relation.NEUTRAL);
        map.put("recruits:bowman", TargetHelper.Relation.NEUTRAL);
        map.put("recruits:recruit_shieldman", TargetHelper.Relation.NEUTRAL);
        map.put("recruits:nomad", TargetHelper.Relation.NEUTRAL);
        map.put("recruits:horseman", TargetHelper.Relation.NEUTRAL);
    }

    private static void addDefaultPiglinRelations(LinkedHashMap<String, TargetHelper.Relation> map) {
        map.put("minecraft:piglin", TargetHelper.Relation.NEUTRAL);
        map.put("minecraft:piglin_brute", TargetHelper.Relation.NEUTRAL);
    }

    public static BMCServerConfig deserialize(String json) {
        return (BMCServerConfig)GSON.fromJson(json, BMCServerConfig.class);
    }

    public String serialize() {
        return GSON.toJson((Object)this);
    }
}

