/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat;

import java.util.function.Function;
import me.Thelnfamous1.bettermobcombat.Constants;
import me.Thelnfamous1.bettermobcombat.client.BetterMobCombatEvents;
import me.Thelnfamous1.bettermobcombat.compatibility.BMCCompatibilityFlags;
import me.Thelnfamous1.bettermobcombat.config.BMCServerConfig;
import me.Thelnfamous1.bettermobcombat.config.BMCServerConfigHelper;
import me.Thelnfamous1.bettermobcombat.config.BMCServerConfigWrapper;
import me.Thelnfamous1.bettermobcombat.logic.MobAttackHelper;
import me.Thelnfamous1.bettermobcombat.platform.Services;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.bettercombat.api.AttackHand;
import net.bettercombat.logic.AnimatedHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;

public class BetterMobCombat {
    private static BMCServerConfig serverConfig;
    private static BMCServerConfigHelper serverConfigHelper;
    private static String serverConfigSerialized;

    public static void init() {
        ConfigHolder configHolder = AutoConfig.register(BMCServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        configHolder.registerSaveListener((ch, scw) -> BetterMobCombat.onConfigUpdated(scw));
        configHolder.registerLoadListener((ch, scw) -> BetterMobCombat.onConfigUpdated(scw));
        BetterMobCombat.updateServerConfig(((BMCServerConfigWrapper)configHolder.getConfig()).server, false);
        BetterMobCombatEvents.ATTACK_START.register((mob, attackHand) -> BetterMobCombat.debugTriggeredAttack(mob, attackHand, MobAttackHelper::getAttackCooldownTicksCapped));
        BMCCompatibilityFlags.initialize();
    }

    private static InteractionResult onConfigUpdated(BMCServerConfigWrapper scw) {
        BetterMobCombat.updateServerConfig(scw.server, true);
        Services.PLATFORM.syncServerConfig();
        return InteractionResult.PASS;
    }

    public static <T extends LivingEntity> void debugTriggeredAttack(T entity, AttackHand attackHand, Function<T, Float> attackCooldownGetter) {
        float upswingRate = (float)attackHand.upswingRate();
        float attackCooldownTicksFloat = attackCooldownGetter.apply(entity).floatValue();
        String animationName = attackHand.attack().animation();
        boolean isOffHand = attackHand.isOffHand();
        AnimatedHand animatedHand = AnimatedHand.from((boolean)isOffHand, (boolean)attackHand.attributes().isTwoHanded());
        Constants.LOG.debug("Triggering attack animation for {} with AnimatedHand {}, animation name {}, length {}, upswing {}", new Object[]{entity, animatedHand, animationName, Float.valueOf(attackCooldownTicksFloat), Float.valueOf(upswingRate)});
    }

    public static BMCServerConfig getServerConfig() {
        return serverConfig;
    }

    public static void updateServerConfig(BMCServerConfig config, boolean log) {
        serverConfig = config;
        serverConfigHelper = new BMCServerConfigHelper(config, log);
        serverConfigSerialized = config.serialize();
        if (log) {
            Constants.LOG.info("Server config updated! {}", (Object)serverConfigSerialized);
        }
    }

    public static String getServerConfigSerialized() {
        return serverConfigSerialized;
    }

    public static BMCServerConfigHelper getServerConfigHelper() {
        return serverConfigHelper;
    }

    static {
        serverConfigSerialized = "";
    }
}

