/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.mixin;

import dqu.additionaladditions.AdditionalRegistry;
import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    protected void injectInEatFoodMethod(Level world, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        if (stack.m_41720_().equals(Items.f_151079_) && Config.getBool(ConfigValues.GLOW_BERRY_GLOW, "enabled")) {
            Integer duration = (Integer)Config.get(ConfigValues.GLOW_BERRY_GLOW, "duration");
            if (duration == null) {
                return;
            }
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, duration * 20, 0, true, false));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void applyFireResistance(CallbackInfo ci) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.isEyeInFluidType((FluidType)ForgeMod.LAVA_TYPE.get()) || this.m_20094_() > 0) {
            return;
        }
        Float durationPerPiece = (Float)Config.get(ConfigValues.GILDED_NETHERITE, "fireResistancePerPiece");
        if (durationPerPiece == null) {
            return;
        }
        float duration = 0.0f;
        for (ItemStack stack : this.m_6168_()) {
            ArmorItem armorItem;
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != AdditionalRegistry.GILDED_NETHERITE_ARMOR_MATERIAL) continue;
            duration += durationPerPiece.floatValue();
        }
        if (duration <= 0.0f) {
            return;
        }
        int durationCeil = (int)Math.ceil(duration);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, durationCeil * 20 + 5, 0, false, false));
    }
}

