/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.MutableHashedLinkedMap;

public enum CreativeAdder {
    TOOLS_AND_UTILITIES,
    INGREDIENTS,
    BUILDING_BLOCKS,
    REDSTONE_BLOCKS,
    FOOD_AND_DRINKS,
    FUNCTIONAL_BLOCKS,
    COMBAT;

    private final List<CreativeEntry> entries = new ArrayList<CreativeEntry>();

    private static void _addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> tabEntries, ItemLike after, ItemLike ... item) {
        for (ItemLike i : item) {
            tabEntries.putAfter((Object)new ItemStack(after), (Object)new ItemStack(i), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static void _addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> tabEntries, ItemLike before, ItemLike ... item) {
        for (ItemLike i : item) {
            tabEntries.putBefore((Object)new ItemStack(before), (Object)new ItemStack(i), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public void add(Supplier<Boolean> condition, ItemLike after, ItemLike ... items) {
        CreativeEntry entry = new CreativeEntry(condition, false, after, items);
        this.entries.add(entry);
    }

    public void addBefore(Supplier<Boolean> condition, ItemLike after, ItemLike ... items) {
        CreativeEntry entry = new CreativeEntry(condition, true, after, items);
        this.entries.add(entry);
    }

    public void pushAllTo(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> content) {
        for (CreativeEntry entry : this.entries) {
            if (!entry.condition.get().booleanValue()) continue;
            if (entry.before) {
                CreativeAdder._addBefore(content, entry.anchor, entry.items);
                continue;
            }
            CreativeAdder._addAfter(content, entry.anchor, entry.items);
        }
    }

    private record CreativeEntry(Supplier<Boolean> condition, boolean before, ItemLike anchor, ItemLike[] items) {
    }
}

