/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.item;

import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class WateringCanItem
extends Item {
    public WateringCanItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        Block block;
        ItemStack stack = player.m_21120_(hand);
        if (!Config.getBool(ConfigValues.WATERING_CAN)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockHitResult hitResult = WateringCanItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockPos pos = hitResult.m_82425_();
        BlockState state = world.m_8055_(pos);
        BlockPos posBelow = pos.m_121945_(Direction.DOWN);
        BlockState stateBelow = world.m_8055_(posBelow);
        if (stack.m_41773_() > 0 || player.m_7500_()) {
            block = state.m_60734_();
            if (block instanceof BonemealableBlock) {
                BonemealableBlock fertilizable = (BonemealableBlock)block;
                if (!(state.m_60734_() instanceof GrassBlock)) {
                    player.m_5496_(SoundEvents.f_144074_, 1.0f, 1.5f);
                    if (world.m_5776_()) {
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    if (fertilizable.m_214167_(world, world.f_46441_, pos, state) && (double)world.f_46441_.m_188501_() < 0.25) {
                        fertilizable.m_214148_((ServerLevel)world, world.f_46441_, pos, state);
                    }
                    if (stateBelow.m_60734_() instanceof FarmBlock) {
                        world.m_46597_(posBelow, (BlockState)stateBelow.m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7)));
                    }
                    stack.m_41721_(stack.m_41773_() - 10);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            }
            if (state.m_60734_() instanceof FarmBlock) {
                if (world.m_5776_()) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7)));
                stack.m_41721_(stack.m_41773_() - 10);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        if ((block = state.m_60734_()) instanceof BucketPickup) {
            BucketPickup fluid = (BucketPickup)block;
            if (state.m_60734_() == Blocks.f_49990_) {
                if (stack.m_41773_() == 100) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                fluid.m_142298_().ifPresent(sound -> player.m_5496_(sound, 1.0f, 1.0f));
                if (!world.m_5776_()) {
                    stack.m_41721_(100);
                    fluid.m_142598_((LevelAccessor)world, pos, state);
                    player.m_6674_(hand);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return Config.getBool(ConfigValues.WATERING_CAN) ? FastColor.ARGB32.m_13660_((int)0, (int)65, (int)135, (int)235) : Mth.m_14159_((float)235.0f, (float)135.0f, (float)65.0f);
    }

    public int m_142158_(ItemStack stack) {
        return Config.getBool(ConfigValues.WATERING_CAN) ? Math.min(Math.round((float)(13 * stack.m_41773_()) / 100.0f), 13) : 13;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        int water = (int)((double)stack.m_41773_() * 0.1);
        String tooltipText = String.format(": %s / 10", water);
        tooltip.add((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("block.minecraft.water", null, (Object[])new String[0])).m_130946_(tooltipText).m_130940_(ChatFormatting.AQUA));
    }
}

