/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dqu.additionaladditions.behaviour.BehaviourManager;
import dqu.additionaladditions.behaviour.BehaviourValues;
import java.util.Locale;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;

public class AdditionalAxeItem
extends AxeItem {
    private Multimap<Attribute, AttributeModifier> modifiers = null;
    private int previousLoads = BehaviourManager.loads;
    private final float attackSpeed;

    public AdditionalAxeItem(Tier material, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(material, (float)attackDamage, attackSpeed, settings);
        this.attackSpeed = attackSpeed;
    }

    private void rebuildModifiers() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.getDamage(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
        this.modifiers = builder.build();
    }

    private void rebuildModifiersIfNeeded() {
        if (this.modifiers == null) {
            this.rebuildModifiers();
            return;
        }
        if (this.previousLoads != BehaviourManager.loads) {
            this.previousLoads = BehaviourManager.loads;
            this.rebuildModifiers();
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        this.rebuildModifiersIfNeeded();
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.modifiers : super.m_7167_(equipmentSlot);
    }

    public float m_8102_(ItemStack itemStack, BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_144280_) ? this.getMiningSpeed() : super.m_8102_(itemStack, blockState);
    }

    public float getDamage() {
        String path = this.m_43314_().toString().toLowerCase(Locale.ROOT) + "/axe";
        Float damage = (Float)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.ATTACK_DAMAGE);
        return damage == null ? super.m_41008_() : damage.floatValue();
    }

    public float getAttackSpeed() {
        String path = this.m_43314_().toString().toLowerCase(Locale.ROOT) + "/axe";
        Float speed = (Float)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.ATTACK_SPEED);
        return speed == null ? this.attackSpeed : speed.floatValue();
    }

    public float getMiningSpeed() {
        String path = this.m_43314_().toString().toLowerCase(Locale.ROOT) + "/axe";
        Float speed = (Float)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.MINING_SPEED);
        return speed == null ? this.f_40980_ : speed.floatValue();
    }
}

