/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dqu.additionaladditions.behaviour.BehaviourManager;
import dqu.additionaladditions.behaviour.BehaviourValues;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;

public class AdditionalArmorItem
extends ArmorItem {
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private Multimap<Attribute, AttributeModifier> modifiers = null;
    private int previousLoads = BehaviourManager.loads;

    public AdditionalArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
        this.rebuildModifiers(type.m_266308_());
    }

    private void rebuildModifiers(EquipmentSlot slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[slot.m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.m_40405_(), AttributeModifier.Operation.ADDITION));
        if (this.getKnockbackResistance() > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.getKnockbackResistance(), AttributeModifier.Operation.ADDITION));
        }
        this.modifiers = builder.build();
    }

    private void rebuildModifiersIfNeeded() {
        if (this.modifiers == null) {
            this.rebuildModifiers(this.m_266204_().m_266308_());
            return;
        }
        if (this.previousLoads != BehaviourManager.loads) {
            this.previousLoads = BehaviourManager.loads;
            this.rebuildModifiers(this.m_266204_().m_266308_());
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        this.rebuildModifiersIfNeeded();
        return this.m_266204_().m_266308_() == equipmentSlot ? this.modifiers : super.m_7167_(equipmentSlot);
    }

    public float m_40405_() {
        if (this.m_266204_().m_266308_().m_20749_() > 3 || this.m_266204_().m_266308_().m_20749_() < 0) {
            return super.m_40405_();
        }
        String path = this.m_40401_().m_6082_() + "/" + AdditionalArmorItem.slotIndexToName(this.m_266204_().m_266308_().m_20749_());
        Float toughness = (Float)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.TOUGHNESS);
        return toughness == null ? super.m_40405_() : toughness.floatValue();
    }

    public int m_40404_() {
        if (this.m_266204_().m_266308_().m_20749_() > 3 || this.m_266204_().m_266308_().m_20749_() < 0) {
            return super.m_40404_();
        }
        String path = this.m_40401_().m_6082_() + "/" + AdditionalArmorItem.slotIndexToName(this.m_266204_().m_266308_().m_20749_());
        Integer defense = (Integer)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.DEFENSE);
        return defense == null ? super.m_40404_() : defense.intValue();
    }

    public float getKnockbackResistance() {
        if (this.m_266204_().m_266308_().m_20749_() > 3 || this.m_266204_().m_266308_().m_20749_() < 0) {
            return 0.0f;
        }
        String path = this.m_40401_().m_6082_() + "/" + AdditionalArmorItem.slotIndexToName(this.m_266204_().m_266308_().m_20749_());
        Float knockback = (Float)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.KNOCKBACK_RESISTANCE);
        return knockback == null ? this.f_40378_ : knockback.floatValue();
    }

    private static String slotIndexToName(int slot) {
        if (slot == 0) {
            return "boots";
        }
        if (slot == 1) {
            return "leggings";
        }
        if (slot == 2) {
            return "chestplate";
        }
        if (slot == 3) {
            return "helmet";
        }
        return null;
    }
}

