/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dqu.additionaladditions.AdditionalAdditions;
import dqu.additionaladditions.AdditionalRegistry;
import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AdditionalLootModifier
extends LootModifier {
    private static final List<LootEntry> entries = new ArrayList<LootEntry>();
    protected final LootItemCondition[] conditions;
    public static final Supplier<Codec<AdditionalLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AdditionalLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AdditionalLootModifier::new)));

    public AdditionalLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.conditions = conditionsIn;
        AdditionalLootModifier.register(EntityType.f_20563_.m_20677_(), () -> Config.getBool(ConfigValues.TRIDENT_SHARD), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.TRIDENT_SHARD.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.33f)));
        AdditionalLootModifier.register(List.of(BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78763_), () -> Config.getBool(ConfigValues.GLOW_STICK), LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)4.0f)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.GLOW_STICK_ITEM.get()))));
        AdditionalLootModifier.register(List.of(BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78763_), () -> Config.getBool(ConfigValues.DEPTH_METER), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.1f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.DEPTH_METER_ITEM.get()))));
        AdditionalLootModifier.register(List.of(BuiltInLootTables.f_78742_, BuiltInLootTables.f_78689_), () -> Config.getBool(ConfigValues.MUSIC_DISCS), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.25f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.MUSIC_DISC_0308.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.MUSIC_DISC_1007.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.MUSIC_DISC_1507.get()))));
        AdditionalLootModifier.register(BuiltInLootTables.f_78694_, () -> Config.getBool(ConfigValues.SHIPWRECK_SPYGLASS_LOOT), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.5f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151059_)));
        AdditionalLootModifier.register(List.of(EntityType.f_20501_.m_20677_(), EntityType.f_20558_.m_20677_()), () -> Config.getBool(ConfigValues.CHICKEN_NUGGET), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.CHICKEN_NUGGET.get()))));
        AdditionalLootModifier.register(BuiltInLootTables.f_78738_, () -> Config.getBool(ConfigValues.GILDED_NETHERITE, "enabled"), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.015f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.GOLD_RING.get()))));
        AdditionalLootModifier.register(List.of(BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78763_), () -> Config.getBool(ConfigValues.ROPES), LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.ROPE_BLOCK.get()))));
        AdditionalLootModifier.register(List.of(BuiltInLootTables.f_78759_, BuiltInLootTables.f_78696_, BuiltInLootTables.f_78690_, BuiltInLootTables.f_78691_, BuiltInLootTables.f_78695_), () -> Config.getBool(ConfigValues.ROSE_GOLD), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.32f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.ROSE_GOLD_UPGRADE.get()))));
        AdditionalLootModifier.register(BuiltInLootTables.f_78701_, () -> Config.getBool(ConfigValues.GILDED_NETHERITE, "enabled"), LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.45f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.GILDED_NETHERITE_UPGRADE.get()))));
        AdditionalLootModifier.postInit();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation id = context.getQueriedLootTableId();
        return AdditionalLootModifier.handle(id, generatedLoot, context);
    }

    public static void register(ResourceLocation table, Supplier<Boolean> condition, LootPool.Builder pool) {
        LootEntry entry = new LootEntry(table, condition, pool);
        entries.add(entry);
    }

    public static void register(List<ResourceLocation> tables, Supplier<Boolean> condition, LootPool.Builder pool) {
        for (ResourceLocation table : tables) {
            AdditionalLootModifier.register(table, condition, pool);
        }
    }

    private static void postInit() {
        AdditionalAdditions.LOGGER.info("[additionaladditions] Adding " + entries.size() + " loot pools");
    }

    private static ObjectArrayList<ItemStack> handle(ResourceLocation id, ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootEntry entry : entries) {
            if (!entry.table.equals((Object)id) || !entry.condition.get().booleanValue()) continue;
            LootPool pool = entry.pool.m_79082_();
            pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    private record LootEntry(ResourceLocation table, Supplier<Boolean> condition, LootPool.Builder pool) {
    }
}

